<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }

        function __construct(){
            // if(session_status() == PHP_SESSION_NONE){
            //     session_start();
            // }

            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial *1;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
				case 0:{
					$num_letra = "0";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
            $numero = $numero*1; 
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero); 
            $num = "cero";
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial*1;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function eliminarTildes($cadena){
			$cadena = str_replace(
				array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
				array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
				$cadena
			);
			
			$cadena = str_replace(
				array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
				array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
				$cadena
			);
			
			$cadena = str_replace(
				array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
				array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
				array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
				array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ñ', 'Ñ', 'ç', 'Ç'),
				array('n', 'N', 'c', 'C'),
				$cadena
			);
			
			return $cadena;
		}

        #   VALOR EN LETRAS
        function valorEnLetras($x){ 
            $I7 = " ";
            $I9 = " ";
            if ($x<0) { $signo = "menos ";} 
            else      { $signo = "";} 
            $x = abs ($x); 
            $C1 = $x; 

            $G6 = floor($x/(1000000));  // 7 y mas 

            $E7 = floor($x/(100000)); 
            $G7 = $E7-$G6*10;   // 6 

            $E8 = floor($x/1000); 
            $G8 = $E8-$E7*100;   // 5 y 4 

            $E9 = floor($x/100); 
            $G9 = $E9-$E8*10;  //  3 

            $E10 = floor($x); 
            $G10 = $E10-$E9*100;  // 2 y 1 


            $G11 = round(($x-$E10)*100,0);  // Decimales 
            ////////////////////// 

            $H6 = $this->unidades($G6); 

            if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
            else {    $H7 = $this->decenas($G7); } 

            $H8 = $this->unidades($G8); 

            if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
            else {    $H9 = $this->decenas($G9); } 

            $H10 = $this->unidades($G10); 

            if($G11 < 10) { $H11 = "0".$G11; } 
            else { $H11 = $G11; } 

            ///////////////////////////// 
                if($G6==0) { $I6=" "; } 
            elseif($G6==1) { $I6="Millón "; } 
                    else { $I6="Millones "; } 

            if ($G8==0 AND $G7==0) { $I8=" "; } 
                    else { $I8="Mil "; } 

            $I10 = ""; 
            $I11 = "/100 US DOLARES ";

            $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

            return $C3; //Retornar el resultado 
        }
        function unidades($u){ 
            if ($u==0)  {$ru = " ";} 
            elseif ($u==1)  {$ru = "Un ";} 
            elseif ($u==2)  {$ru = "Dos ";} 
            elseif ($u==3)  {$ru = "Tres ";} 
            elseif ($u==4)  {$ru = "Cuatro ";} 
            elseif ($u==5)  {$ru = "Cinco ";} 
            elseif ($u==6)  {$ru = "Seis ";} 
            elseif ($u==7)  {$ru = "Siete ";} 
            elseif ($u==8)  {$ru = "Ocho ";} 
            elseif ($u==9)  {$ru = "Nueve ";} 
            elseif ($u==10) {$ru = "Diez ";} 

            elseif ($u==11) {$ru = "Once ";} 
            elseif ($u==12) {$ru = "Doce ";} 
            elseif ($u==13) {$ru = "Trece ";} 
            elseif ($u==14) {$ru = "Catorce ";} 
            elseif ($u==15) {$ru = "Quince ";} 
            elseif ($u==16) {$ru = "Dieciseis ";} 
            elseif ($u==17) {$ru = "Decisiete ";} 
            elseif ($u==18) {$ru = "Dieciocho ";} 
            elseif ($u==19) {$ru = "Diecinueve ";} 
            elseif ($u==20) {$ru = "Veinte ";} 

            elseif ($u==21) {$ru = "Veintiun ";} 
            elseif ($u==22) {$ru = "Veintidos ";} 
            elseif ($u==23) {$ru = "Veintitres ";} 
            elseif ($u==24) {$ru = "Veinticuatro ";} 
            elseif ($u==25) {$ru = "Veinticinco ";} 
            elseif ($u==26) {$ru = "Veintiseis ";} 
            elseif ($u==27) {$ru = "Veintisiente ";} 
            elseif ($u==28) {$ru = "Veintiocho ";} 
            elseif ($u==29) {$ru = "Veintinueve ";} 
            elseif ($u==30) {$ru = "Treinta ";} 

            elseif ($u==31) {$ru = "Treinta y un ";} 
            elseif ($u==32) {$ru = "Treinta y dos ";} 
            elseif ($u==33) {$ru = "Treinta y tres ";} 
            elseif ($u==34) {$ru = "Treinta y cuatro ";} 
            elseif ($u==35) {$ru = "Treinta y cinco ";} 
            elseif ($u==36) {$ru = "Treinta y seis ";} 
            elseif ($u==37) {$ru = "Treinta y siete ";} 
            elseif ($u==38) {$ru = "Treinta y ocho  ";} 
            elseif ($u==39) {$ru = "Treinta y nueve ";} 
            elseif ($u==40) {$ru = "Cuarenta ";} 

            elseif ($u==41) {$ru = "Cuarenta y un ";} 
            elseif ($u==42) {$ru = "Cuarenta y dos ";} 
            elseif ($u==43) {$ru = "Cuarenta y tres ";} 
            elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
            elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
            elseif ($u==46) {$ru = "Cuarenta y seis ";} 
            elseif ($u==47) {$ru = "Cuarenta y siete ";} 
            elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
            elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
            elseif ($u==50) {$ru = "Cincuenta ";} 

            elseif ($u==51) {$ru = "Cincuenta y un ";} 
            elseif ($u==52) {$ru = "Cincuenta y dos ";} 
            elseif ($u==53) {$ru = "Cincuenta y tres ";} 
            elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
            elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
            elseif ($u==56) {$ru = "Cincuenta y seis ";} 
            elseif ($u==57) {$ru = "Cincuenta y siete ";} 
            elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
            elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
            elseif ($u==60) {$ru = "Sesenta ";} 

            elseif ($u==61) {$ru = "Sesenta y un ";} 
            elseif ($u==62) {$ru = "Sesenta y dos ";} 
            elseif ($u==63) {$ru = "Sesenta y tres ";} 
            elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
            elseif ($u==65) {$ru = "Sesenta y cinco ";} 
            elseif ($u==66) {$ru = "Sesenta y seis ";} 
            elseif ($u==67) {$ru = "Sesenta y siete ";} 
            elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
            elseif ($u==69) {$ru = "Sesenta y nueve ";} 
            elseif ($u==70) {$ru = "Setenta ";} 

            elseif ($u==71) {$ru = "Setenta y un ";} 
            elseif ($u==72) {$ru = "Setenta y dos ";} 
            elseif ($u==73) {$ru = "Setenta y tres ";} 
            elseif ($u==74) {$ru = "Setenta y cuatro ";} 
            elseif ($u==75) {$ru = "Setenta y cinco ";} 
            elseif ($u==76) {$ru = "Setenta y seis ";} 
            elseif ($u==77) {$ru = "Setenta y siete ";} 
            elseif ($u==78) {$ru = "Setenta y ocho  ";} 
            elseif ($u==79) {$ru = "Setenta y nueve ";} 
            elseif ($u==80) {$ru = "Ochenta ";} 

            elseif ($u==81) {$ru = "Ochenta y un ";} 
            elseif ($u==82) {$ru = "Ochenta y dos ";} 
            elseif ($u==83) {$ru = "Ochenta y tres ";} 
            elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
            elseif ($u==85) {$ru = "Ochenta y cinco ";} 
            elseif ($u==86) {$ru = "Ochenta y seis ";} 
            elseif ($u==87) {$ru = "Ochenta y siete ";} 
            elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
            elseif ($u==89) {$ru = "Ochenta y nueve ";} 
            elseif ($u==90) {$ru = "Noventa ";} 

            elseif ($u==91) {$ru = "Noventa y un ";} 
            elseif ($u==92) {$ru = "Noventa y dos ";} 
            elseif ($u==93) {$ru = "Noventa y tres ";} 
            elseif ($u==94) {$ru = "Noventa y cuatro ";} 
            elseif ($u==95) {$ru = "Noventa y cinco ";} 
            elseif ($u==96) {$ru = "Noventa y seis ";} 
            elseif ($u==97) {$ru = "Noventa y siete ";} 
            elseif ($u==98) {$ru = "Noventa y ocho  ";} 
            else            {$ru = "Noventa y nueve ";} 
            return $ru; //Retornar el resultado 
        } 
        function decenas($d){ 
            if ($d==0)  {$rd = "";} 
            elseif ($d==1)  {$rd = "Ciento ";} 
            elseif ($d==2)  {$rd = "Doscientos ";} 
            elseif ($d==3)  {$rd = "Trescientos ";} 
            elseif ($d==4)  {$rd = "Cuatrocientos ";} 
            elseif ($d==5)  {$rd = "Quinientos ";} 
            elseif ($d==6)  {$rd = "Seiscientos ";} 
            elseif ($d==7)  {$rd = "Setecientos ";} 
            elseif ($d==8)  {$rd = "Ochocientos ";} 
            else            {$rd = "Novecientos ";} 
            return $rd; //Retornar el resultado 
        }

    	//Cortes De Caja-------------------------------------------------------------------------------------------------------------------
		function imprimirApertura($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = strtoupper($this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5)));
				$direccion = strtoupper($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

                $fechaImpre = new DateTime();
                $fechaImpre = $fechaImpre->format('d/m/Y');

                $horaCorte = date_format(date_create($fechaactual), 'H:i');
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);

				$cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "APERTURA DE CAJA";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function reporteCorteX($fechaactual, $idcentro, $idcaja){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes

                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function reporteCorteZFacturaz($fechaactual, $idcentro, $idcaja){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz; 
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
      
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }
        function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               
                
				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                          
                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }
        function impresionCorteZMensual($idanio, $idmes, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;

                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                switch ($idmes) {
                    case 1:
                        $nameMes = 'ENERO';
                        break;
                    case 2:
                        $nameMes = 'FEBRERO';
                        break;
                    case 3:
                        $nameMes = 'MARZO';
                        break;
                    case 4:
                        $nameMes = 'ABRIL';
                        break;
                    case 5:
                        $nameMes = 'MAYO';
                        break;
                    case 6:
                        $nameMes = 'JUNIO';
                        break;
                    case 7:
                        $nameMes = 'JULIO';
                        break;
                    case 8:
                        $nameMes = 'AGOSTO';
                        break;
                    case 9:
                        $nameMes = 'SEPTIEMBRe';
                        break;
                    case 10:
                        $nameMes = 'OCTUBRE';
                        break;
                    case 11:
                        $nameMes = 'NOVIEMBRE';
                        break;
                    case 12:
                        $nameMes = 'DICIEMBRE';
                        break;
                    default:
                        break;
                }

                $infoCortes = $this->ventas_model->getNumeroZCorteMensual($idcentro, $idcaja, $idanio, $idmes);
                $documentos = $this->ventas_model->tipos_doc_ventas_cortez_mensual($idcentro, $idcaja, $idanio, $idmes);
                $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZMensual($idcentro, $idcaja, $idanio, $idmes);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= $namecentro;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr('GIRO: '.$GIRO, 0, 64);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>64){
                    $cmds .= substr($GIRO ,39,78);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z MENSUAL";
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 56);
                $cmds .= comandosTM::LineFeed;

                $cmds .= $nameMes." ".$idanio;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "IMPRESO ".$date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Zeta #", 7, "BOTH");
                $cmds .= $comandosTM->padText("Dia", 4, "BOTH");
                $cmds .= $comandosTM->padText("Gravadas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Exentas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Total", 10, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $totalglobal=0; $totalexglobal=0; $totalgrglobal=0; $totalivglobal=0;
                foreach($infoCortes as $info){
                    $subtotal = 0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    
                    $infoDocumentos = $this->ventas_model->getDocumentosVentasCorteZMensual($idcentro, $idcaja, $info->numz);
                    foreach($infoDocumentos as $ven){
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $ven->exento;
                        $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }
                        
                        $subtotalex = $subtotalex + $totalExento;
                        $subtotalgr = $subtotalgr + $totalGravado + $totalIVA;
                        $subtotaliv = $subtotaliv + $totalIVA;
                        $totalNumeroZ = $subtotalex + $subtotalgr;
                    }
                    $cmds .= $comandosTM->padText($info->numz, 7, "BOTH");
                    $cmds .= $comandosTM->padText($info->dia, 4, "BOTH");
                    $cmds .= $comandosTM->padText(number_format($subtotalgr, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($subtotalex, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalNumeroZ, 2, '.', ''), 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;

                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                    $totalglobal   = $totalgrglobal + $totalexglobal;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 11, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalgrglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalexglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "RESUMEN DE DOCUMENTOS";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Desde", 9, "BOTH");
                $cmds .= $comandosTM->padText("Hasta", 9, "BOTH");
                $cmds .= $comandosTM->padText("#", 9, "BOTH");
                $cmds .= $comandosTM->padText("Valor", 12, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                $numdocg = 0; $j=0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    $t = 0;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(3);
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                            $invexento = $ven->exento;
                            $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                            
                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            $numdoc++; $numdocg++; $numFinal = $ven->numero;
                            $t++;
                        }
                        $j++;
                    }
                    $cmds .= $comandosTM->padText($numInicial, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numFinal, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numdoc, 9, "BOTH");
                    $cmds .= $comandosTM->padText(number_format(round($subtotal, 2), 2, '.', ''), 12, "LEFT");
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal   = $totalglobal + $subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 18, "LEFT");
                $cmds .= $comandosTM->padText($j, 9, "BOTH");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 12, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'F.________________________________________';
                $cmds .= comandosTM::LineFeed;

                $cmds .= trim($this->session->userdata('userLog'));
                $cmds .= comandosTM::LineFeed;

                $cmds .= $date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'CZM'.$idanio. $idmes. $idcentro. $idcaja;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZP($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);   
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."assets/js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."assets/js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."assets/js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.20';
					var devid = 'local_printer';
					var timeout = '600000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
                            
							$productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
			
				/*
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				*/
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2), 2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2), 2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
										
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText('".$date->format('d/m/Y H:i:s A')."').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					//setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}

	    //Facturacion-----------------------------------------------------------------------------------------------------------------------------------
		function ventaTicketFinal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    //$zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    //var_dump($info->idzip);
                    //$depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
            
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "0x1B"."i";


                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }

                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function printDevolucion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    //$zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    //$depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
            
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "0x1B"."i";

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
               
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function facturaConsumidorFinalOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = $dtpagos->descrip;
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetMargins(10, 10, 12, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                //$this->highlight_array($informacion);
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                  
                    //
                    
                    $pdf->SetXY( 20, 41 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,50), true, false, true, false, '');

                    $pdf->SetXY( 160, 41 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 23, 47 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,50), true, false, true, false, '');

                    $duinit = "";
                    if($info->dui != ""){
                        $duinit = $info->dui;
                    }elseif($info->nit != ""){
                        $duinit = $info->nit;
                    }

                    $pdf->SetFont('monospace1', '', 8, '', true);
                    $pdf->SetXY( 162, 47 );
                    $pdf->writeHTML($duinit, true, false, true, false, '');

                    $pdf->SetFont('monospace1', '', 7, '', true);
                    //
                    $pdf->SetXY( 12, 53 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),50,50), true, false, true, false, '');

                    $pdf->SetXY( 163, 53 );
                    $pdf->writeHTML(substr(strtoupper($payment),0,50), true, false, true, false, '');

                    //
                   
                    //
                   
                }

                #   PRODUCTOS
            
                $maxlines = 10;
                $maxcaracteres = 65;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                //$this->highlight_array($productos);
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        }   

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 4 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 7mm">';
                        $tablaProductos .= '<td style="width: 9%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:48%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $pdf->SetFont('monospace1', '', 8, '', true);

                        $tablaProductos .= '<td style="width: 9%; text-align: right;">'.number_format($preciouni,2,'.','').'</td>';
                        $tablaProductos .= '<td style="width:19%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right;">'.$vnGravada.'</td>';
                        $pdf->SetFont('monospace1', '', 7, '', true);

                        $tablaProductos .= '</tr>';

                        $numProd++;

                       
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 10, 72 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;

                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;
                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != ""){
                    $subtotal = $subtotal + $totalExento; 
                }

                $total = $subtotal;
                if($retencion != ""){
                    $total = $total - $retencion; 
                }    
              
                
                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 25, 142 );
                $pdf->writeHTML(substr($TotalLetras,0,60), true, false, true, false, '');

                $pdf->SetXY( 25, 146 );
                $pdf->writeHTML(substr($TotalLetras,60,60), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 100%; text-align: right; line-height: 5.8mm;" ';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';
                

                $pdf->SetXY( 175, 142 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaConsumidorFinalOld1($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = $dtpagos->descrip;
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetMargins(10, 10, 12, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                //$this->highlight_array($informacion);
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                  
                    //
                    
                    $pdf->SetXY( 20, 41 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,50), true, false, true, false, '');

                    $pdf->SetXY( 160, 41 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 23, 47 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,50), true, false, true, false, '');

                    $duinit = "";
                    if($info->dui != ""){
                        $duinit = $info->dui;
                    }elseif($info->nit != ""){
                        $duinit = $info->nit;
                    }

                    $pdf->SetFont('monospace1', '', 8, '', true);
                    $pdf->SetXY( 162, 47 );
                    $pdf->writeHTML($duinit, true, false, true, false, '');

                    $pdf->SetFont('monospace1', '', 7, '', true);
                    //
                    $pdf->SetXY( 12, 53 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),50,50), true, false, true, false, '');

                    $pdf->SetXY( 163, 53 );
                    $pdf->writeHTML(substr(strtoupper($payment),0,50), true, false, true, false, '');

                    //
                   
                    //
                   
                }

                #   PRODUCTOS
            
                $maxlines = 10;
                $maxcaracteres = 65;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                //$this->highlight_array($productos);
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        }   

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 4 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 7mm">';
                        $tablaProductos .= '<td style="width: 9%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width: 10%; text-align: left;">'. $pro->modelo .'</td>';
                        $tablaProductos .= '<td style="width:38%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $pdf->SetFont('monospace1', '', 8, '', true);

                        $tablaProductos .= '<td style="width: 9%; text-align: right;">'.number_format($preciouni,2,'.','').'</td>';
                        $tablaProductos .= '<td style="width:19%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right;">'.$vnGravada.'</td>';
                        $pdf->SetFont('monospace1', '', 7, '', true);

                        $tablaProductos .= '</tr>';

                        $numProd++;

                       
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 10, 72 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;

                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;
                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != ""){
                    $subtotal = $subtotal + $totalExento; 
                }

                $total = $subtotal;
                if($retencion != ""){
                    $total = $total - $retencion; 
                }    
              
                
                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 25, 142 );
                $pdf->writeHTML(substr($TotalLetras,0,60), true, false, true, false, '');

                $pdf->SetXY( 25, 146 );
                $pdf->writeHTML(substr($TotalLetras,60,60), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 100%; text-align: right; line-height: 5.8mm;" ';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';
                

                $pdf->SetXY( 175, 142 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaConsumidorFinalOld2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = $dtpagos->descrip;
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                //$this->highlight_array($informacion);
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $vendedor = $info->nameVendedor;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                  
                    //

                    $pdf->SetXY( 156 + 2, 36.5 + 3.5 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');

                    $pdf->SetXY( 21 + 2, 36.5 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,63), true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 22 + 2, 42.8 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->direccion)),0,33), true, false, true, false, '');
                    
                    $pdf->SetXY( 12 + 2, 48.8 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->direccion)),33,38), true, false, true, false, '');

                    //

                    $pdf->SetXY( 160 + 2, 42.8 + 3.5 );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //$pdf->SetXY( 136 + 2, 42.8 + 3.5 );
                    //$pdf->writeHTML(/*$info->dui*/12345678-9, true, false, true, false, '');

                    //
                    
                    $pdf->SetXY( 162 + 2, 48.8 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($payment)),0,20), true, false, true, false, '');

                    //$pdf->SetXY( 162 + 2, 48.8 + 3.5 );
                    //$pdf->writeHTML(substr(strtoupper($this->eliminarTildes($vendedor)),0,20), true, false, true, false, '');
                   
                }

                #   PRODUCTOS
            
                $maxlines = 14;
                $maxcaracteres = 50;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                //$this->highlight_array($productos);
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                        }   

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 4 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 6.9mm">';
                        $tablaProductos .= '<td style="width:9.3%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right;">'.number_format($preciouni,2,'.','').'</td>';
                        $tablaProductos .= '<td style="width:9%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';

                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 9.1, 63.2 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;

                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;
                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != ""){
                    $subtotal = $subtotal + $totalExento; 
                }

                $total = $subtotal;
                if($retencion != ""){
                    $total = $total - $retencion; 
                }    
              
                
                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 165 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 168 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,40,40), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';


                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';   
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';
                

                $pdf->SetXY( 184.8, 163.2 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaConsumidorFinal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = $dtpagos->descrip;
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                //$this->highlight_array($informacion);
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $vendedor = $info->nameVendedor;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                  
                    //

                    $pdf->SetXY( 158 + 2, 36.3 + 3.5 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');

                    $pdf->SetXY( 21 + 2, 36.3 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,63), true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 22 + 2, 42.5 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->direccion)),0,33), true, false, true, false, '');
                    
                    $pdf->SetXY( 12 + 2, 47.8 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->direccion)),33,38), true, false, true, false, '');

                    //
                    $pdf->SetXY( 162 + 2, 42.2 + 3.5 );
                    $pdf->writeHTML(($info->dui == '') ? $info->nit : $info->dui, true, false, true, false, '');

                    //
                    $pdf->SetXY( 164 + 2, 47.8 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($payment)),0,20), true, false, true, false, '');

                    $pdf->SetXY( 164 + 2, 53.6 + 3.5 );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($vendedor)),0,20), true, false, true, false, '');
                   
                }

                #   PRODUCTOS
            
                $maxlines = 10;
                $maxcaracteres = 50;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                //$this->highlight_array($productos);
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                        }   

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 4 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 6.9mm">';
                        $tablaProductos .= '<td style="width:9.3%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right;">'.number_format($preciouni,2,'.','').'</td>';
                        $tablaProductos .= '<td style="width:9%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';

                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 10.1, 66.2 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;

                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;
                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != ""){
                    $subtotal = $subtotal + $totalExento; 
                }

                $total = $subtotal;
                if($retencion != ""){
                    $total = $total - $retencion; 
                }    
              
                
                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 18 + 4, 139 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 18 + 4, 142 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,40,40), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';


                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';   
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';
                

                $pdf->SetXY( 184.8, 137.2 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(9, 11, 13, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                    
                    $pdf->SetXY( 20, 41 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,58), true, false, true, false, '');

                    $pdf->SetXY( 117, 41 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    $pdf->SetXY( 162, 41 );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');

                    //
                    $pdf->SetXY( 23, 47 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,70), true, false, true, false, '');

                    $duinit = "";
                    if($info->dui != ""){
                        $duinit = $info->dui;
                    }elseif($info->nit != ""){
                        $duinit = $info->nit;
                    }

                    $pdf->SetXY( 155, 47 );
                    $pdf->writeHTML($duinit, true, false, true, false, '');
                    //
                    
                    $pdf->SetXY( 23, 52 );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,60), true, false, true, false, '');
                    
                    $pdf->SetXY( 115, 52 );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,58), true, false, true, false, '');
                    
                    //

                    $pdf->SetXY( 141, 58 );
                    $pdf->writeHTML(substr(strtoupper($payment),0,40), true, false, true, false, '');
                
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 65;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height:5.8mm">';
                        $tablaProductos .= '<td style="width:10%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:49%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right; font-size: 9px;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 9px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 7, 71 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 21, 137 );
                $pdf->writeHTML(substr($TotalLetras,0,60), true, false, true, false, '');

                $pdf->SetXY( 21, 141 );
                $pdf->writeHTML(substr($TotalLetras,60,60), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 100%; text-align: right; line-height: 5.8mm;" ';

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 175, 136 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld1($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(9, 11, 13, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                    
                    $pdf->SetXY( 20, 41 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,58), true, false, true, false, '');

                    $pdf->SetXY( 117, 41 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    $pdf->SetXY( 162, 41 );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');

                    //
                    $pdf->SetXY( 23, 47 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,70), true, false, true, false, '');

                    $duinit = "";
                    if($info->dui != ""){
                        $duinit = $info->dui;
                    }elseif($info->nit != ""){
                        $duinit = $info->nit;
                    }

                    $pdf->SetXY( 155, 47 );
                    $pdf->writeHTML($duinit, true, false, true, false, '');
                    //
                    
                    $pdf->SetXY( 23, 52 );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,60), true, false, true, false, '');
                    
                    $pdf->SetXY( 115, 52 );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,58), true, false, true, false, '');
                    
                    //

                    $pdf->SetXY( 141, 58 );
                    $pdf->writeHTML(substr(strtoupper($payment),0,40), true, false, true, false, '');
                
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 65;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height:5.8mm">';
                        $tablaProductos .= '<td style="width:10%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: left;">'. $pro->modelo .'</td>';
                        $tablaProductos .= '<td style="width:39%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right; font-size: 9px;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 9px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:15%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 7, 71 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 21, 137 );
                $pdf->writeHTML(substr($TotalLetras,0,60), true, false, true, false, '');

                $pdf->SetXY( 21, 141 );
                $pdf->writeHTML(substr($TotalLetras,60,60), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 100%; text-align: right; line-height: 5.8mm;" ';

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 175, 136 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();
                $x = 3; $y = 3;
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                
                    
                    $pdf->SetXY( 21 + $x, 38.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 115 + $x, 38.5 + $y );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');
                    
                    $pdf->SetXY( 159.6 + $x, 38.5 + $y );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    
                    $pdf->SetXY( 23 + $x, 44.8 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,40), true, false, true, false, '');
                    
                    //$pdf->SetXY( 12 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($info->direccion),30,34), true, false, true, false, '');

                    $pdf->SetXY( 153 + $x, 44.8 + $y );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    $pdf->SetXY( 23 + $x, 51.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($municipio),0,30), true, false, true, false, '');

                    $pdf->SetXY( 115 + $x, 51.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,20), true, false, true, false, '');

                    $pdf->SetXY( 153 + $x, 51.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,20), true, false, true, false, '');

                    //$pdf->SetXY( 53 + $x, 57.4 + $y );
                    //$pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->nameVendedor)),0,20), true, false, true, false, '');

                    $pdf->SetXY( 135 + $x, 57.4 + $y );
                    $pdf->writeHTML(substr(strtoupper($payment),0,20), true, false, true, false, '');

                   
                }

                #   PRODUCTOS
              

                $maxlines = 15;
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height: 5.9mm">';
                        $tablaProductos .= '<td style="width:9.3%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:7%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 9.1, 69 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 160.7 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,35), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 164 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,35,35), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
            
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 181, 159.3 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld3($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();
                $x = 3; $y = 3;
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                
                    
                    $pdf->SetXY( 21 + $x, 38.2 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 115 + $x, 38.2 + $y );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');
                    
                    $pdf->SetXY( 159.6 + $x, 38.2 + $y );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    
                    $pdf->SetXY( 23 + $x, 44.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,40), true, false, true, false, '');
                    
                    //$pdf->SetXY( 12 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($info->direccion),30,34), true, false, true, false, '');

                    $pdf->SetXY( 153 + $x, 44.5 + $y );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //$pdf->SetXY( 23 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($municipio),0,30), true, false, true, false, '');

                    $pdf->SetXY( 23 + $x, 50.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,20), true, false, true, false, '');

                    $pdf->SetXY( 153 + $x, 50.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,20), true, false, true, false, '');

                    $pdf->SetXY( 119 + $x, 50.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->nameVendedor)),0,14), true, false, true, false, '');

                    $pdf->SetXY( 135 + $x, 55.7 + $y );
                    $pdf->writeHTML(substr(strtoupper($payment),0,20), true, false, true, false, '');

                   
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height: 5.9mm">';
                        $tablaProductos .= '<td style="width:9.3%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:7%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 9.1, 68.1 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 135.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,35), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 139.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,35,35), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
            
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 181, 134.4 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld4($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();
                $x = 3; $y = 3;
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                
                    
                    $pdf->SetXY( 21 + $x, 31.9 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 119 + $x, 31.9 + $y );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');
                    
                    $pdf->SetXY( 166.1 + $x, 31.9 + $y );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    
                    $pdf->SetXY( 23 + $x, 38.2 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,40), true, false, true, false, '');
                    
                    //$pdf->SetXY( 12 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($info->direccion),30,34), true, false, true, false, '');

                    $pdf->SetXY( 158 + $x, 38.2 + $y );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //$pdf->SetXY( 23 + $x, 44.5 + $y );
                    //$pdf->writeHTML(substr(strtoupper($municipio),0,30), true, false, true, false, '');

                    $pdf->SetXY( 23 + $x, 44.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,20), true, false, true, false, '');

                    $pdf->SetXY( 160 + $x, 44.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,20), true, false, true, false, '');

                    $pdf->SetXY( 126 + $x, 44.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->nameVendedor)),0,14), true, false, true, false, '');

                    $pdf->SetXY( 135 + $x, 50.1 + $y );
                    $pdf->writeHTML(substr(strtoupper($payment),0,20), true, false, true, false, '');

                   
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height: 5.9mm">';
                        $tablaProductos .= '<td style="width:9.8%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:9.2%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 8.1, 65.1 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 135.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,35), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 139.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,35,35), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
            
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 183, 134.4 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalOld5($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();
                $x = 3; $y = 3;
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                
                    
                    $pdf->SetXY( 21 + $x, 35 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 119 + $x, 35 + $y );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');
                    
                    $pdf->SetXY( 166.1 + $x, 35 + $y );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    
                    $pdf->SetXY( 23 + $x, 41 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,40), true, false, true, false, '');
                    
                    //$pdf->SetXY( 12 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($info->direccion),30,34), true, false, true, false, '');

                    $pdf->SetXY( 158 + $x, 41 + $y );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //$pdf->SetXY( 23 + $x, 44.5 + $y );
                    //$pdf->writeHTML(substr(strtoupper($municipio),0,30), true, false, true, false, '');

                    $pdf->SetXY( 23 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,20), true, false, true, false, '');

                    $pdf->SetXY( 116 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,35), true, false, true, false, '');

                    $pdf->SetXY( 86 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->nameVendedor)),0,14), true, false, true, false, '');

                    $pdf->SetXY( 140 + $x, 52.2 + $y );
                    $pdf->writeHTML(substr(strtoupper($payment),0,20), true, false, true, false, '');

                   
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height: 5.9mm">';
                        $tablaProductos .= '<td style="width:9.8%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:8.5%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 9.1, 65.1 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 135.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,45), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 139.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,45,45), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
            
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 183, 130.4 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();
                $x = 3; $y = 3;
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper($dtpagos->descrip);
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobante Crédito Fiscal');
                $pdf->SetSubject('Comprobante Crédito Fiscal');
                $pdf->SetMargins(11, 10, 15, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';
                
                    
                    $pdf->SetXY( 21 + $x, 35 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 119 + $x, 35 + $y );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');
                    
                    $pdf->SetXY( 166.1 + $x, 35 + $y );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    
                    $pdf->SetXY( 23 + $x, 41 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,40), true, false, true, false, '');
                    
                    //$pdf->SetXY( 12 + $x, 50.1 + $y );
                    //$pdf->writeHTML(substr(strtoupper($info->direccion),30,34), true, false, true, false, '');

                    $pdf->SetXY( 158 + $x, 41 + $y );
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //$pdf->SetXY( 23 + $x, 44.5 + $y );
                    //$pdf->writeHTML(substr(strtoupper($municipio),0,30), true, false, true, false, '');

                    $pdf->SetXY( 23 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($departamento),0,20), true, false, true, false, '');

                    $pdf->SetXY( 116 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,35), true, false, true, false, '');

                    $pdf->SetXY( 86 + $x, 46.5 + $y );
                    $pdf->writeHTML(substr(strtoupper($this->eliminarTildes($info->nameVendedor)),0,14), true, false, true, false, '');

                    $pdf->SetXY( 140 + $x, 52.2 + $y );
                    $pdf->writeHTML(substr(strtoupper($payment),0,20), true, false, true, false, '');

                   
                }

                #   PRODUCTOS
              

                $maxlines = 11;
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->modelo)).' '.trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height: 5.9mm;">';
                        $tablaProductos .= '<td style="width:9.8%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:47%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:8.5%; text-align: right;"></td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 9.1, 65.1 + 3.5 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15 + 4, 135.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,0,45), true, false, true, false, '');

                $pdf->SetXY( 15 + 4, 139.4 + 3.5 );
                $pdf->writeHTML(substr($TotalLetras,45,45), true, false, true, false, '');
                $pdf->SetMargins(11, 10, 11, true);

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 5.9mm;" ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 5.8mm; "';
                $pdf->SetFont('monospace1', '', 8, '', true);

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
            
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 183, 130.4 + 3.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

             
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Credito_Fiscal'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function notaDeCredito($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = $dtpagos->descrip;
                }
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Nota de Crédito');
                $pdf->SetSubject('Nota de Crédito');
                $pdf->SetMargins(7, 11, 86, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 6, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    /* --- INICIO SECCION CABECERAS --- */ 
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';

                     
                    $pdf->SetXY( 93, 46 );
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');
                    //
                    
                    $pdf->SetXY( 19, 52 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,70), true, false, true, false, '');
                    //

                    $pdf->SetXY( 22, 57 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,43), true, false, true, false, '');

                

                    $pdf->SetXY( 88, 57);
                    $pdf->writeHTML(substr(strtoupper($departamento),0,60), true, false, true, false, '');
                    //

                    $pdf->SetXY( 16, 64 );
                    $pdf->writeHTML(substr(strtoupper($info->giro),0,30), true, false, true, false, '');

                    $duinit = "";
                    if($info->dui != ""){
                        $duinit = $info->dui;
                    }elseif($info->nit != ""){
                        $duinit = $info->nit;
                    }

                    $pdf->SetFont('monospace1', '', 6.5, '', true);
                    $pdf->SetXY( 59, 64 );
                    $pdf->writeHTML($duinit, true, false, true, false, '');

                    $pdf->SetFont('monospace1', '', 6.5, '', true);
                    $pdf->SetXY( 91, 64 );
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');
                    //

                    $pdf->SetXY( 36, 69 );
                    $pdf->writeHTML($payment, true, false, true, false, '');
                }

                #   PRODUCTOS
              

                $maxlines = 18;
                $maxcaracteres = 44;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 

                $tablaProductos = '<table style="width: 100%; padding: 0;">';
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');

                        }else if($pro->tax1 != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            $vnGravada = "";
                        }

                        $preciouni = $pro->precioneto;
                        $preciouni = number_format(abs($preciouni), 4 ,'.','');
                        if($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                        }
                        
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                    
                        }                       
                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad!=0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '<tr style="line-height:3.8mm">';
                        $tablaProductos .= '<td style="width:10%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:45%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right;">'.number_format($preciouni,4,'.','').'</td>';
                        $tablaProductos .= '<td style="width:21%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';


                        $numProd++;
                    }
                }

                $tablaProductos .= '</table>';
                $pdf->SetXY( 7, 88 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                if($retencion != "") {
                    $total = $total - $retencion;
                }
                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                $numero = number_format(round($total, 2), 2 ,'.','');
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 15, 160 );
                $pdf->writeHTML(substr($TotalLetras,0,60), true, false, true, false, '');

                $pdf->SetXY( 15, 164 );
                $pdf->writeHTML(substr($TotalLetras,60,60), true, false, true, false, '');
              
                $estiloTotal = 'style="width: 100%; text-align: right; line-height: 5.3mm;" ';

                $tablaTotales ='<table style="width: 100%; padding: 0;">';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$subtotal.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .='</table>';

               
                $pdf->SetXY( 113, 159 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');

            
                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode('Nota_Credito'.$trannum.'pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaExportacionOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura de Exportación');
                $pdf->SetSubject('Factura de Exportación');
                $pdf->SetMargins(10, 9, 12, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                $tipocliente = 0;
                foreach($detailPagos as $dtpagos){
                    $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                }
                foreach($informacion as $info){
                    $idcps = $info->idcps;
                    $tipocliente = $info->idtipo;
                }
                $cant_ = 0;
                $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                foreach($infoGzips as $infg){
                    $departamento = trim($infg->depto);
                    $municipio = trim($infg->municipio);
                }
                #   INFORMACION
                foreach($informacion as $info){
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';

                    //
                    $pdf->SetXY( 20, 40);
                    $pdf->writeHTML(strtoupper(substr($info->nameCliente, 0, 80)), true, false, true, false, '');

                    $pdf->SetXY( 157, 40);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    //
                    $pdf->SetXY( 25, 46);
                    $pdf->writeHTML(strtoupper(substr($info->direccion, 0, 80)), true, false, true, false, '');

                    $pdf->SetXY( 155, 46);
                    $pdf->writeHTML($info->nit, true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 12, 51);
                    $pdf->writeHTML(strtoupper(substr($info->direccion, 60, 55)), true, false, true, false, '');
                }
                #   PRODUCTOS
                $maxlines = 15;//11
                $maxcaracteres = 80;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $tablaProductos = '<table  style="width: 100%; padding:0px;">';

                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0;
                $lineamenosproduct = 0;
                $lineadescuento = 0;
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;
                        if($pro->descuento != "" && $pro->descuento != 0 && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;
                        }                            
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        }                              $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="width: 9%;  text-align: center; font-weight: normal;" >'.$cantidadPro.'</td>
                                <td style="width: 65%;  text-align: left; font-weight: normal;" >'.substr($nombrepro, 0, $maxcaracteres).'</td>
                                <td style="width: 11%;  text-align: right; font-weight: normal;" >'.number_format($preciouni, 4 ,'.','').'</td>
                                <td style="width: 15%; text-align: right; font-weight: normal;" >'.$vnExenta.'</td>
                            </tr>';
                        $numProd++;

                        
                    }
                }
                $tablaProductos .= '</table>';

                $pdf->SetXY( 10, 65);
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                #   TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');

                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else $retencion = number_format(round($retencion, 2), 2 ,'.','');
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)));

                $pdf->SetXY( 22, 113);
                $pdf->writeHTML(substr($TotalLetras, 0, 80), true, false, true, false, '');

                $pdf->SetXY( 22, 116);
                $pdf->writeHTML(substr($TotalLetras, 80, 80), true, false, true, false, '');

                $totalGravIva = $totalGravado + $totalIVA;
                $tablaTotales = '
                    <table style="width: 100%; padding:0px;">
                        <tr>
                            <td style="width: 100%; text-align: right;font-size: 10px;">'.number_format(round($total, 2), 2 ,'.','').'</td>
                        </tr>
                    
                    </table>
                ';//*/

                $pdf->SetXY( 175, 113);
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                
            

                $nombre_archivo = utf8_decode("Factura_Exportacion_".$trannum.".pdf");
                $js = 'print(true);';
                // set javascript
                $pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaExportacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura de Exportación');
                $pdf->SetSubject('Factura de Exportación');
                $pdf->SetMargins(10, 9, 12, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 7, '', true);
                $pdf->addPage('P', 'LETTER');

                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVenta($trannum);
                $tipocliente = 0;
                foreach($detailPagos as $dtpagos){
                    $payment=strtoupper(substr($dtpagos->descrip, 0, 18))/*' - '.$info->dias.' DIAS'*/;
                }
                foreach($informacion as $info){
                    $idcps = $info->idcps;
                    $tipocliente = $info->idtipo;
                }
                $cant_ = 0;
                $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
                foreach($infoGzips as $infg){
                    $departamento = trim($infg->depto);
                    $municipio = trim($infg->municipio);
                }
                #   INFORMACION
                foreach($informacion as $info){
                    $testing = '123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*';

                    //
                    $pdf->SetXY( 20, 40);
                    $pdf->writeHTML(strtoupper(substr($info->nameCliente, 0, 80)), true, false, true, false, '');

                    $pdf->SetXY( 157, 40);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    //
                    $pdf->SetXY( 25, 46);
                    $pdf->writeHTML(strtoupper(substr($info->direccion, 0, 80)), true, false, true, false, '');

                    $pdf->SetXY( 155, 46);
                    $pdf->writeHTML($info->nit, true, false, true, false, '');
                    
                    //
                    $pdf->SetXY( 12, 51);
                    $pdf->writeHTML(strtoupper(substr($info->direccion, 60, 55)), true, false, true, false, '');
                }
                #   PRODUCTOS
                $maxlines = 15;//11
                $maxcaracteres = 80;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $tablaProductos = '<table  style="width: 100%; padding:0px;">';

                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0;
                $lineamenosproduct = 0;
                $lineadescuento = 0;
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;
                        if($pro->descuento != "" && $pro->descuento != 0 && $vnGravada != ""){
                            $discount =  ($pro->descuento/100) * $vnGravada;
                        }                            
                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        }                              $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');
                        
                        $tablaProductos .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="width: 9%;  text-align: center; font-weight: normal;" >'.$cantidadPro.'</td>
                                <td style="width: 10%;  text-align: left; font-weight: normal;" >'. $pro->modelo .'</td>
                                <td style="width: 55%;  text-align: left; font-weight: normal;" >'.substr($nombrepro, 0, $maxcaracteres).'</td>
                                <td style="width: 11%;  text-align: right; font-weight: normal;" >'.number_format($preciouni, 4 ,'.','').'</td>
                                <td style="width: 15%; text-align: right; font-weight: normal;" >'.$vnExenta.'</td>
                            </tr>';
                        $numProd++;

                        
                    }
                }
                $tablaProductos .= '</table>';

                $pdf->SetXY( 10, 65);
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                #   TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');

                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else $retencion = number_format(round($retencion, 2), 2 ,'.','');
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)));

                $pdf->SetXY( 22, 113);
                $pdf->writeHTML(substr($TotalLetras, 0, 80), true, false, true, false, '');

                $pdf->SetXY( 22, 116);
                $pdf->writeHTML(substr($TotalLetras, 80, 80), true, false, true, false, '');

                $totalGravIva = $totalGravado + $totalIVA;
                $tablaTotales = '
                    <table style="width: 100%; padding:0px;">
                        <tr>
                            <td style="width: 100%; text-align: right;font-size: 10px;">'.number_format(round($total, 2), 2 ,'.','').'</td>
                        </tr>
                    
                    </table>
                ';//*/

                $pdf->SetXY( 175, 113);
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');
                
            

                $nombre_archivo = utf8_decode("Factura_Exportacion_".$trannum.".pdf");
                $js = 'print(true);';
                // set javascript
                $pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        

		//Reportes----------------------------------------------------------------------------------------------------------------------------

		function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
				}
				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:20%;"></td>
									<td style="font-size:15px; text-align:center;width:80%;">'.strtoupper($nombreFormato).'</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
                    
                $header .= '
                <table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:'.$background_color.'; width:37.5%; font-weight: bold; border: 1px solid '.$background_color.';" > Origen</td>
						<td style="font-size:12px; text-align:left; background-color:'.$background_color.'; width:37.5%; font-weight: bold; border: 1px solid '.$background_color.';" > Destino</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:25%; font-weight: bold; border: 1px solid '.$background_color.';" colspan="2"> Datos de Orden</td>
					</tr>
				</table>';
                $header .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-top: 1px solid '.$background_color.';" rowspan="2"> '.$data->centrocd.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-top: 1px solid '.$background_color.';" rowspan="2"> '.$data->idcentrod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> N°:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$data->trannum.'</td>
					</tr>
                    <tr>
						<td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> Fecha:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$date_emision.'</td>
					</tr>
                    <tr>
                        <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-bottom: 1px solid '.$background_color.';"> '.$data->encargadoinv.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-bottom: 1px solid '.$background_color.';"> '.$data->encargadod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> Estado:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$estado.'</td>
					</tr>
                    </table>';
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#2675a3;">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #2675a3; border-top: 1px solid #2675a3;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:'.$background_color.';">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #2675a3;  width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:'.$background_color.'; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:'.$background_color.'; width:59%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:'.$background_color.'; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                                        <th style="background-color:'.$background_color.'; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:'.$background_color.'; width:9%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                        <th style="background-color:'.$background_color.';border-right: 1px solid #2675a3; width:1%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:'.$background_color.';">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #6E6E6E; border-bottom: 1px solid #2675a3;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  1px solid '.$background_color.'; ">
                                <td style="width:5%; border-left: 1px solid '.$background_color.';  text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:6%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:59%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:9%; text-align:center; font-size:10px;  border-bottom:solid 1px black;"></td>
                                <td style="width:1%;border-right: 1px solid #2675a3;  text-align:center; font-size:10px;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='
                    <tr><td style="font-size:5px; width:100%;border-left:1px solid #2675a3;border-right:1px solid #2675a3;"></td></tr>
                    
                    <tr style="border:1px solid #2675a3; font-size:12px;">
                        <td style="width:5%;border-top:1px solid #2675a3;border-bottom:1px solid '.$background_color.';border-left:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="width:75%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(number_format(round($totalcant, 2),2)).'</strong></td>
                        <td style="width:10%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';border-right:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                     $titulo .= '
                      <table>
                    <tr>
				        <td style="width:100%;"><br><br></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Entregado por</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Recibido por</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Fecha y hora</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function reporteDetalleComponentes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Detalle de Componentes');
                $pdf->SetSubject('Detalle de Componentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('produccion_model'); $this->load->model('global_model');
				$this->load->model('variable_model'); $this->load->model('pedclientes_model');
				
                $funcion = $this->uri->segment(3);
				$info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $name = $this->pedclientes_model->getnameImg();
				$nombreFormato = $this->global_model->getFormatosNombre($funcion);
				
				$infoLineas = $this->produccion_model->getListadoLineasCombos(4);
				
				foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
				}

				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
				
				$estructura = '<style> .fondo{ background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center; } </style>';
				
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px; margin:0px; width:80%;">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>'.strtoupper($nombreFormato).'</b></td>
								</tr>
							</table>
						</td>
						<td style="padding:0px; margin:0px; width:20%;">
							<img style="text-align:right; width:200px; height:90px;margin-top:-20px; margin-bottom:0px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
						</td>
                    </tr>
				</table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
				$pdf->addPage('P', 'LETTER');
				
				foreach($infoLineas as $infLin){
					$infoProductos = $this->produccion_model->getListadoProductosConComponentes($infLin->idcatalogo);
					$estructura .= '
					<table style="width:100%;">
						<tr>
							<td style="border:1px solid #000; background-color:#000; color:#FFF; font-weight:bold; padding:0px; margin:0px; width:100%; font-size:14px;">'.strtoupper($infLin->descrip).'</td>
						</tr>
					</table>';
					
					foreach($infoProductos as $infPro){
						$estructura .= '
						<table style="width:100%;">
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; padding:0px; margin:0px; width:10%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->idproducto.'</td>
								<td style="padding:0px; margin:0px; width:50%; font-size:11px; font-weight:bold;">'.$infPro->descrip.'</td>
								<td style="padding:0px; margin:0px; width:15%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->um.'</td>
								<td style="padding:0px; margin:0px; width:15%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->modelo.'</td>
								<td style="border-right:1px solid #000; padding:0px; margin:0px; width:10%; font-size:12px; font-weight:bold; text-align:center;">$'.number_format($infPro->precioventa, 2, '.', '').'</td>
							</tr>
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
						</table>';

						$infoCProductos = $this->produccion_model->getListadoCProductos($infPro->idproducto);

						foreach($infoCProductos as $infCP){
							if($infCP->ptipo == 4){
								$comentTipo = '<b style="color:red; font-size:12px;">*</b>';
							}else{
								$comentTipo = '';
							}
							$estructura .= '
							<table style="width:100%;">
								<tr style="width:100%;">
									<td style="border-left:1px solid #000; padding:0px; margin:0px; width:10%; font-size:11px; text-align:center;">'.$infCP->idproducto.'</td>
									<td style="padding:0px; margin:0px; width:35%; font-size:10px;">'.$infCP->descrip.' '.$comentTipo.'</td>
									<td style="padding:0px; margin:0px; width: 5%; font-size:10px; text-align:center;">'.number_format($infCP->uniconv, 2, '.', '').'</td>
									<td style="padding:0px; margin:0px; width:10%; font-size:11px; text-align:center;">'.$infCP->um.'</td>
									<td style="padding:0px; margin:0px; width:15%; font-size:11px; text-align:center;">'.$infCP->modelo.'</td>
									<td style="border-right:1px solid #000; padding:0px; margin:0px; width:25%; font-size:11px; text-align:center;">'.$infCP->tipo.'</td>
								</tr>
							</table>';
						}

						$estructura .= '
						<table style="width:100%;">
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-bottom:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
						</table>';
					}

					$estructura .= '<br><br>';
				}
                                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("ReporteComponentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function reporteDetalleComponentes2(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Detalle de Componentes');
                $pdf->SetSubject('Detalle de Componentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('produccion_model'); $this->load->model('global_model');
				$this->load->model('variable_model'); $this->load->model('pedclientes_model');
				
                $funcion = $this->uri->segment(3);
				$info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $name = $this->pedclientes_model->getnameImg();
				$nombreFormato = $this->global_model->getFormatosNombre($funcion);
												
				foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
				}

				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
				
				$estructura = '<style> .fondo{ background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center; } </style>';
				
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px; margin:0px; width:80%;">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>'.strtoupper($nombreFormato).'</b></td>
								</tr>
							</table>
						</td>
						<td style="padding:0px; margin:0px; width:20%;">
							<img style="text-align:right; width:200px; height:90px;margin-top:-20px; margin-bottom:0px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
						</td>
                    </tr>
				</table>';

				$estructura .= '<table id="ContentPlaceHolder1_TPensum" class="table table-bordered">
				<tbody><tr>
					<td class="otra">Nivel</td>
					<td colspan="6" class="PCell"></td>
				</tr>
				<tr>
					<td align="center">1</td>
					<td align="center"><table id="ContentPlaceHolder1_CAD501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">CAD501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Diferencial</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_COE201" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">COE201</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Comunicación Oral y Escrita</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PRE104" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">PRE104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación Estructurada</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_QUG501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">QUG501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Química General</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">2</td>
					<td align="center"><table id="ContentPlaceHolder1_AVM501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">AVM501</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Álgebra Vectorial y Matrices</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CAI501" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">CAI501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Integral</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAD501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CDP501" name="N" class="PD" >
						<tbody><tr>
							<td class="PCell">CDP501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cinemática y Dinámica de Partículas</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAD501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_MDB104" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">MDB104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Modelamiento y Diseño de Base de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_POO104" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">POO104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación Orientada a Objetos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">3</td>
					<td align="center"><table id="ContentPlaceHolder1_ADS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ADS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis y Diseño de Sistemas Informáticos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104, POO104</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CVV501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">CVV501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo de Varias Variables</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AVM501, CAI501</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ESA501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ESA501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Estadística Aplicada</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_EYM501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">EYM501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Electricidad y Magnetismo</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501, CDP501, QUG501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PED104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">PED104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación con Estructuras de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">POO104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">4</td>
					<td align="center"><table id="ContentPlaceHolder1_CAA501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">CAA501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Avanzado</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CVV501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DMD104" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">DMD104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Datawarehouse y Minería de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_EDI501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">EDI501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Ecuaciones Diferenciales</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CVV501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_LIC104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">LIC104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Lenguajes Interpretados en el Cliente</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104, POO104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_OFC501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">OFC501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Oscilaciones, Fluidos y Calor</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501, CDP501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">5</td>
					<td align="center"><table id="ContentPlaceHolder1_ACE102" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ACE102</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis de Circuitos Eléctricos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">EYM501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ACO101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ACO101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Arquitectura de Computadoras</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">EYM501, PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_AEE106" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AEE106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis y Evaluación Económica</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ESA501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ANF231" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">ANF231</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Antropología Filosófica</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_GEA106" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">GEA106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Gestión Ambiental</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">QUG501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">6</td>
					<td align="center"><table id="ContentPlaceHolder1_DDP106" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DDP106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Dirección de Proyectos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AEE106, GEA106</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DRD101" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">DRD101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño de Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PSC231" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">PSC231</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Pensamiento Social y Cristiano</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SIO104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">SIO104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Sistemas Operativos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ACO101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">7</td>
					<td align="center"><table id="ContentPlaceHolder1_AMN501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AMN501</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Aplicación de Métodos Numéricos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ACE102, EDI501, PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_IRD101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">IRD101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Interconexión de Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ISO104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ISO104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Ingeniería de Software</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ADS104, DDP106</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_LIS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">LIS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Lenguajes Interpretados en el Servidor</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">LIC104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">8</td>
					<td align="center"><table id="ContentPlaceHolder1_AYC104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AYC104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Autómatas y Compiladores</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AMN501, PED104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DPS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DPS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño y Programación de Software Multiplataforma</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DMD104, PED104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSS101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSS101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño de Sist. de Seg. p/ Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_GCS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">GCS104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Gestión de la Calidad del Software</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">9</td>
					<td align="center"><table id="ContentPlaceHolder1_ASR104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ASR104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Adm. e Implem. de Serv. de Red con Sist. Oper. Propietarios</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSM104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSM104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Desarrollo de Software para Móviles</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DPS104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_NTI104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">NTI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Normalización de Tecnologías de la Información</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SGC104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">SGC104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Sem de Gestión del Conoc. /Ing. en CC de Comput.</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SSI104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">SSI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Seguridad Informática</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_STI104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">STI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Gobierno de TI</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">10</td>
					<td align="center"><table id="ContentPlaceHolder1_ASI104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ASI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Admin. e Impl. Serv. de Red con Sist. Operativos Libres</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_AUS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AUS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Auditoría de Sistemas</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSE104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSE104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Desarrollo de Software Empresarial</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DMD104, LIS104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SCN104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SCN104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Gestión de la Continuidad del Negocio</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">STI104</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SGA104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SGA104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Aplicación del Conocimiento para Ingeniería en CC de la Computación</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">SGC104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SIN104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SIN104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Inteligencia de Negocios</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">SSI104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
			</tbody></table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage('P', 'LETTER');
                                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("ReporteComponentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}

        function comprasReport($provee, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Compras');
                $pdf->SetSubject('Reporte de Compras');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Reporte de Compras</label><br><label style="text-align:center; font-size:13px;">Periodo del '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $tipopro = $this->session->userdata('tipoprod');
                $idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('compras_model');
                $this->load->model('auxi_model');
                
                $titulo='<table>
                <thead>
                <tr>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Línea</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cod.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Modelo</td>
                        <td style="width:35%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Descripción</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">UM</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Lote</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cant.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Costo Unitario</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Sub Total</td>
                    </tr>
                </thead><tbody>';
                
                
                $lst_provee = explode("-", $provee);
                $tot = count($lst_provee);
                $total_ = $tot;
                $titulo2='';
                $total_general = 0;
                $totalGravado = 0;
                $totalIVA = 0;
                $totalExento = 0;
                for($j=0; $j<$total_; $j++){
                    $name_provee = $this->auxi_model->getNameAuxi($lst_provee[$j]);
                    $titulo2='<tr><th colspan="9"><br></th></tr><tr><th colspan="9" style="font-size:15px; color: #0B486B;">'.$name_provee.'</th></tr>';
                    $ordenes = $this->compras_model->getListadoOrdenesReport("CO", $tipopro, $idcentro, $fechaini, $fechafin, $lst_provee[$j]);
                    $or=0;
                    foreach($ordenes as $or){
                        $or++;
                        $titulo2.= '<tr style="line-height: 4mm">
                        <td style="width:1%;  border-top:1px solid #343838; border-bottom:1px solid #343838; "></td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:11px; text-align:left;">Fecha: '.$or->fecha1.'</td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:11px; text-align:left;">Cierre: '.$or->fecha2.'</td>
                        <td style="width:39%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:11px; text-align:left;">N°: '.$or->serie.$or->numero.'</td></tr>';
                        if($or->notas!="" && $or->notas!=null){
                        $titulo2.= '<tr>
                            <td style="width:1%;"></td>
                            <td colspan="8" style="width:99%;font-size:12px; text-align:left; color:gray; ">&nbsp;&nbsp;&nbsp;&nbsp;'.$or->notas.'</td></tr>';
                        }
                        $titulo2 .='<tr>
                            <td style="width:25%; text-align:right; font-size:3px;"></td>
                            <td style="width:25%; text-align:right; font-size:3px;"></td>
                            <td style="width:25%; text-align:right; font-size:3px;"></td>
                            <td style="width:25%; text-align:right; font-size:3px;"></td>
                        </tr>';
                        $exentas=0;
                        $gravadas=0;
                        $iva=0;
                        $total_iva=0;
                        $detalle_orden = $this->compras_model->getDetalleByEstatusCompraLocal($or->trannum, $or->estatus);
                        foreach($detalle_orden as $detail){
                            $subtotal = $detail->cantidad * $detail->preciotran;
                            $titulo2 .= '
                            <tr>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->itemline.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->idproducto.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->modelo.'</td>
                                <td style="width:35%; font-size:9px; text-align:left; font-color: black;">'.$detail->descrip.'</td>
                                <td style="width:10%; font-size:9px; text-align:center; font-color: black;">'.$detail->um.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->lote.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.number_format(round($detail->cantidad, 0),0).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">'.$this->session->userdata("simboloMoneda").number_format(round($detail->preciotran, 4),4).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</td>
                            </tr>';
                            if($detail->tax1==0){
                                $exentas = $exentas+$subtotal;
                            }else{
                                $subtotal_coniva = $subtotal;
                                $subtotal_siniva = $subtotal*(($detail->tax1/100));
                                $gravadas = $gravadas+$subtotal_coniva;
                                $iva = $subtotal_siniva;
                                $total_iva = $total_iva + $iva;
                            }
                        }
                        
                        
                        $subtotal = $exentas+$gravadas+$total_iva;
                        $totalExento += $exentas;
                        $totalGravado += $gravadas;
                        $totalIVA += $total_iva;
                        $total_general += $subtotal;


                        $titulo2 .='<tr>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                        </tr>';
                        
                        $titulo2 .='<tr>
                            <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Exentas</td>
                            <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($exentas, 2),2).' </td>

                            <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Gravadas</td>
                            <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($gravadas, 2),2).' </td>

                            <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">IVA</td>
                            <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($total_iva, 2),2).' </td>

                            <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Total</td>
                            <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).' </td>

                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                            <td style="width:25%; text-align:right; font-size:6px;"></td>
                        </tr>';
                        
                    }
                    if($or!="0"){
                        $titulo.= $titulo2;
                    }
                    
                }         

                $titulo .='<tr>
                    <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Total<br>Exentas</td>
                    <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).' </td>

                    <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Total<br>Gravadas</td>
                    <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).' </td>

                    <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Total<br>IVA</td>
                    <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($totalIVA, 2),2).' </td>

                    <td style="width: 10%; text-align: center; font-size:11px; border: 1px solid #343838;">Total</td>
                    <td style="width: 15%; text-align:right; font-size:11px;font-weight:bold; border: 1px solid #343838; padding-right: 5px">'.$this->session->userdata("simboloMoneda").number_format(round($total_general, 2),2).' </td>

                </tr>';
                    
                /*
                $titulo .='<tr><th><br></th></tr>
                <tr>
                    <td style="width:80%; text-align:right; font-size:11px;font-weight:bold;">Total:</td>
                    <td style="width:20%; text-align:right; font-size:11px;font-weight:bold;">'.$this->session->userdata("simboloMoneda").number_format(round($total_general, 2),2).'</td>
                </tr>';
                */
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        //-----------------------------------------------------------

        function facturaConsumidorFinalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaConsumidorFinalDTE/' . $trannum);
            }
        }

        function comprobanteCreditoFiscalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/comprobanteCreditoFiscalDTE/' . $trannum);
            }
        }

        function facturaDeExportacionDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaDeExportacionDTE/' . $trannum);
            }
        }

        function notaDeCreditoDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/notaDeCreditoDTE/' . $trannum);
            }
        }

        //------ PEGAR FORMATOS ACA --------------

        function creditoFiscalElectronicBills($trannum, $idYear = 0, $docToSend = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                    redirect('login/cerrar_sesion');
            } else {
                    $this->load->model('dev_model');
                    $this->load->model('dte_model');
                    $this->load->model('global_model');
                    $this->load->model('pedclientes_model');
                    $this->load->model('ventas_model');
                    $this->load->model('invtran_model');
                    $this->load->model('sucursal_model');

                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Documento Tributario Electrónico');
                    $pdf->SetSubject('Documento Tributario Electrónico');
                    $pdf->SetMargins(7.5, 15, 9, true);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetAutoPageBreak(TRUE, 7);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('helvetica', '', 7.5, '', true);
                    $pdf->addPage('P', 'LETTER');

                    $x = 3;
                    $y = 3;

                    $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                    foreach ($informacion as $info) {
                            $jsonInfo = $info['jsonDoc'];
                            $sRecepcion = $info['sRecepcion'];
                            $respHacienda = $info['respHacienda'];
                            $firmaJson = $info['firmaJson'];
                    }

                    if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                    if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                    if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                    if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                    if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                    if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                    if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                    if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                    if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                    if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                    if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                    if (isset($resumen['tributos'])) $tributos  = $resumen['tributos']; else $tributos = array();
                    if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                    if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                    $tipoDocumento = '';
                    $nameVendedor = '';
                    $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                    $infoFact = $this->ventas_model->getDatosFactura($trannum);

                    foreach ($infoFact as $info) {
                            $idClase = $info->idclase;
                            $nameSucursal = $info->nameSucursal;
                            $nameVendedor = $info->nameVendedor;
                            $referenciaOT = $info->referencia;
                            $idCliente = (int) $info->idcliente;
                            $idCentro = (int) $info->idcentro;
                            $extension['observaciones'] = $info->notas;
                    }

                    if ( $dteSucursal == 0 ) {
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                        $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                        $nameImagen = $this->pedclientes_model->getnameImg();
                    } else {
                        $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                        $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                        $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                        $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                    }

                    $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                    $modeloFacturacion = explode(" ", $modFac['descrip']);
                    $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                    $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                    $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                    $tipoDocumento = $identificacion['tipoDte'];

                    $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                    if ($sucursalInfo != false || $sucursalInfo != null) {
                        if ($sucursalInfo->direccion != '') {
                            $direcEmisor['complemento'] = $sucursalInfo->direccion;
                        }
    
                        if ($sucursalInfo->telefono != '') {
                            $emisor['telefono'] = $sucursalInfo->telefono;
                        }
                    }

                    /* --- INICIO SECCION CABECERAS --- */
                    $emisorEstab = array();
                    if (isset($emisor['tipoEstablecimiento'])) {
                            $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                    }

                    if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                    $imgHeader1Hght = '20px';
                    if($this->session->userdata('idaccount') == '1937326') {
                        $imgHeader1Hght = '73px';
                    }

                    if($this->session->userdata('idaccount') == '90476') {
                        $imgHeader1Hght = '15px';
                        if ($idCentro == 2) {
                            $nameImagen = 'BostonLogo.png';
                        }
                    }

                    $fontSize = '9.5px';
                    if($this->session->userdata('idaccount') == '1784550') {
                        $fontSize = '8.5px';
                    }

                    if($this->session->userdata('idaccount') == '2922210'){
                        $header1 = '
                            <table style="width:100%; padding:0px;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                                </tr>';
                            $header1 .= '</table>';
                    } else{
                        $header1 = '
                            <table style="width:100%; padding:0px;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 112).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                                </tr>';
                                if($this->session->userdata('idaccount') == '2585TIENDAS'){
                                    $header1 .=
                                        '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                        </tr>';
    
                                }else{
                                    $header1 .= 
                                        '<tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                        </tr>';
                                }
                            $header1 .=
                                '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                                </tr>';
                            $header1 .= '</table>';
                    }

                    $header2 = '
                        <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                    $nControlP = explode('-', $identificacion['numeroControl']);

                    $header2 .= '
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                            </tr>';
                    $header2 .= '</table>';

                    $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D' . $identificacion['ambiente'] . '%26codGen%3D' . $identificacion['codigoGeneracion'] . '%26fechaEmi%3D' . $identificacion['fecEmi'] . '&size=79x79" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                            <br><br>
                                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['codigoGeneracion'] . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                            <br><br>
                                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $sRecepcion . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                            <br><br>
                                            <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['numeroControl'] . '&size=60x60" />
                            </td>
                        </tr>
                    </table>';

                    if (isset($direcReceptor)) {
                            $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                            $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                    } else {
                            $receptorMun = array();
                            $receptorDep = array();
                    }

                    if (isset($direcRsujetoExcluido)) {
                            $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                            $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                    } else {
                            $sujetoExcluidoMun = array();
                            $sujetoExcluidoDep = array();
                    }

                    $receptorDoc = array();
                    if (isset($receptor['tipoDocumento'])) {
                            if ($receptor['tipoDocumento'] != '') {
                                    $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                            }
                    }

                    $sujetoExcluidoDoc = array();
                    if (isset($sujetoExcluido['tipoDocumento'])) {
                            if ($sujetoExcluido['tipoDocumento'] != '') {
                                    $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                            }
                    }

                    if (!isset($receptorDoc['descrip'])) {
                            $receptorDoc['descrip'] = 'Doc. Identificación';
                    }

                    if (!isset($sujetoExcluidoDoc['descrip'])) {
                            $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                    }

                    if (!isset($receptor['nombreComercial'])) {
                            $receptor['nombreComercial'] = '';
                    }

                    if (!isset($direcReceptor['complemento'])) {
                            $direcReceptor['complemento'] = '';
                    }

                    if (!isset($direcRsujetoExcluido['complemento'])) {
                            $direcRsujetoExcluido['complemento'] = '';
                    }

                    if (!isset($receptor['correo'])) {
                            $receptor['correo'] = '';
                    }

                    $condicionPago = array();
                    if (isset($resumen['condicionOperacion'])) {
                            if ($resumen['condicionOperacion'] != '') {
                                    $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                            }
                    } else {
                            $condicionPago['descrip'] = '';
                    }

                    if (!isset($extension['observaciones'])) {
                            $extension['observaciones'] = '';
                    }

                    if (!isset($extension['nombEntrega'])) {
                            $extension['nombEntrega'] = '';
                    }

                    if (!isset($extension['docuEntrega'])) {
                            $extension['docuEntrega'] = '';
                    }

                    if (!isset($extension['nombRecibe'])) {
                            $extension['nombRecibe'] = '';
                    }

                    if (!isset($extension['docuRecibe'])) {
                            $extension['docuRecibe'] = '';
                    }

                    $direcFontSize = '8px';
                    
                    if (strlen($direcReceptor['complemento']) > 89) {
                        $direcFontSize = '7.5px';
                    }

                    $ordenString = '';
                    if ($this->session->userdata('idaccount') == '291862') {
                        $ordenString = 'Orden:';
                    } else {
                        $referenciaOT = '';
                    }

                    $header3 = '
                        <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">'. $ordenString .'</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.trim($referenciaOT).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nit'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . substr($receptor['correo'], 0, 64) . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['nrc'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">' . mb_strtoupper($direcReceptor['complemento'], 'UTF-8') . '</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($receptor['telefono'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                    foreach ($receptorMun as $muni) {
                            $header3 .= '
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                            break;
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr($condicionPago['descrip'], 0, 19) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                    foreach ($receptorDep as $depto) {
                            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                            break;
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Moneda:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">' . substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19) . '</td>
                            </tr>
                    </table>';

                    $header = '<table style="width:100%; margin:0; padding:0;">
                                    <tr>
                                                    <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                                                    <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                                    </tr>
                                    <tr>
                                                    <td style="margin:0; padding:0;">' . $qrCode . '</td>
                                    </tr>
                                    <tr>
                                                    <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                                    </tr>
                    </table>';

                    //$pdf->setPrintHeader(true);
                    //$pdf->setHTMLHeader($header);

                    $qrCodeLabel = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Portal de Hacienda</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Cód. Generación</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>Sello Recibido</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <p>N° de Control</p>
                            </td>
                        </tr>
                    </table>';

                    $pdf->SetXY(4.5 + $x, 10.5 + $y);
                    $pdf->writeHTML($header, true, false, true, false, '');

                    $pdf->SetXY(86.5 + $x, 57 + $y);
                    $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

                    /* --- FIN SECCION CABECERAS --- */

                    //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                    /* --- INICIO SECCION PRODUCTOS --- */

                    $cantLines = 0;
                    $lineasPorProducto = 0;
                    foreach($cuerpoDocumento as $body){
                        $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                        $cantLines += $lineasPorProducto;
                    }

                    if ($cantLines <= 40) {
                        $cantPages = 1;
                    } elseif ($cantLines > 40 && $cantLines <= 113) {
                        $cantPages = 2;
                    } else {
                        $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
                    }
    
                    $numProd = 0;
                    $maxlines = 40;
    
                    $docLines = count($cuerpoDocumento);
                    if ($docLines <= 40) {
                        $maxlines = 40;
                    } else {
                        if ($docLines > 40 && $docLines <= 113) {
                            if ($docLines <= 44) {
                                $maxlines = 40;
                            } else {
                                $maxlines = 48;
                            }
                        } else if ($docLines > 113) {
                            $maxlines = 48;
                        }
                    }

                    $stop_index = $maxlines;
                    $aux2 = 1;

                    $productos = $this->invtran_model->getDataTran100k($trannum);
                    $total = 0;
                    $totalGravado = 0;
                    $totalExento = 0;
                    $totalIVA = 0;
                    //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                    $invexento = 0;
                    $vnExenta = 0;
                    $vnGravada = 0;
                    $numProd = 0; //linea echa para poder visualizar el pdf
                    $ivaCesc = 0;
                    $cesc = 0;
                    $lineasOcupa = 0;
                    $totalDesc = 0;
                    $discount = 0;

                    $bodyDoc = '
                    <table style="width:100%; padding:0px;">
                    <thead>
                        <tr style="width:100%; padding:0px;">
                                        <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Modelo</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                        </tr>
                    </thead>';

                    foreach ($productos as $pro) {
                            //if($numProd < $maxlines){
                            /*$ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                            $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                            if($ventaNosj == '0'){
                                            $ventaNosj = '';
                            }
                            if($ventaExenta == '0'){
                                            $ventaExenta = '';
                            }*/

                            if ($pro->tax1 != 0 && $invexento == 0) {
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "";
                                    //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                                    $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                            } else if ($pro->tax1 != 0 && $invexento == 1) {
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 0) {
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            } else if ($pro->tax1 == 0 && $invexento == 1) {
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                    $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4, '.', '');
                                    $vnGravada = "";
                            }

                            $ivaSepa = 1 + ($pro->tax1 / 100);
                            $preciouni = $pro->precioneto;
                            if ($pro->descuento != 0 && $pro->descuento != "" && $vnGravada != "") {
                                    $discount =  ($pro->descuento / 100) * $preciouni;
                                    $totalDesc += $discount * abs($pro->cantidad);
                            }

                            if ($pro->notas != "") {
                                    $notas = strtoupper(trim($pro->notas));
                            } else {
                                    $notas = "";
                            }

                            if ($pro->tipo == "4") {
                                    $idpro = "";
                                    $nombrepro = strtoupper(trim($notas));

                                    if ( $nombrepro == '' ) {
                                        $nombrepro = strtoupper(trim($pro->descrip));
                                    }
                            } else {
                                    $idpro = $pro->idproducto;
                                    $nombrepro = strtoupper(trim($pro->descrip)).' '.$notas;
                            }

                            $sumacantidad = (number_format(abs($pro->cantidad), 4, '.', '') - number_format(abs($pro->cantidad), 0, '.', ''));
                            if ($sumacantidad != 0) $cantidadPro = number_format(abs($pro->cantidad), 2, '.', '');
                            else $cantidadPro = number_format(abs($pro->cantidad), 0, '.', '');

                            if ($numProd >= $stop_index) {
                                    $breakValue = 'always';
                                    $numProd = 0;
                                    $aux2++;
                            } else {
                                    $breakValue = 'avoid';
                            }

                            $wrapped = wordwrap(trim(mb_strtoupper($nombrepro, 'UTF-8')), 57, '<br>');

                            $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">' . $pro->itemline . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">' . $cantidadPro . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $pro->modelo . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">' . $wrapped . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . number_format($preciouni, 6, '.', '') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnExenta . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">' . $vnGravada . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                            </tr>';

                            if ($aux2 > 1 && $aux2 <= $cantPages) {
                                $stop_index = 65;
                            }

                            $totalDesc = 0;
                            $numProd += ceil(strlen($nombrepro) / 57);
                            //$numProd++;
                            //}
                    }

                    if ($cantPages > 1) {
                        $maxlines = 65;
                    }

                    for ($i = $numProd; $i < $maxlines; $i++) {
                        $bodyDoc .= '
                        <tr>
                            <td style="font-size: 9px; text-align:center; width:100%;"></td>
                        </tr>';
                    }
                    //$bodyDoc .='</table>';

                    //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                    //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    /* --- INICIO SECCION TOTALES --- */

                    /* --- INICIO SECCION EXTENSION --- */

                    $extention = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">' . trim($resumen['totalLetras']) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuEntrega'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">' . substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . $extension['docuRecibe'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                        </tr>';
                    if ($extension['observaciones'] == '') {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) <= 86) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else if (strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344) {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">' . trim($extension['observaciones']) . '</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    } else {
                            $extention .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">' . substr(trim($extension['observaciones']), 0, 430) . '</td>
                            </tr>';
                    }

                    $extention .= '
                    </table>';

                    //$pdf->SetXY( 4.5, 210 );
                    //$pdf->writeHTML($extention, true, false, true, false, '');

                    /* --- INICIO SECCION TOTALES --- */

                    $totals = '
                    <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; margin: 0px;">
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalNoSuj'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalExenta'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalGravada'], 2, '.', ',') . '</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotalVentas'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total descuentos</td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalDescu'], 2, '.', ',') . '</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        </tr>';
                    foreach ($tributos as $trib) {
                            $totals .= '
                            <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">' . $trib["descripcion"] . '</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($trib["valor"], 2, '.', ',') . '</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';

                        $resumen['subTotal'] = floatval($trib["valor"]) + floatval($resumen['subTotal']);
                    }
                    $totals .= '
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['subTotal'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaPerci1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['ivaRete1'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">' . number_format($resumen['totalPagar'], 2, '.', ',') . '</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                            </tr>
                    </table>';

                    //$pdf->SetXY( 128.4, 210 );
                    //$pdf->writeHTML($totals, true, false, true, false, '');

                    /* --- FIN SECCION TOTALES --- */

                    $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                    //$pdf->SetXY( 4.5, 265 );
                    //$pdf->writeHTML($message, true, false, true, false, '');

                    $bodyDoc .= '
                        <tr style="width:100%; margin: 0px; padding: 0px;">
                            <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                            <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                        </tr>
                        <tr style="width:100%;">
                            <td style="width:1%; margin: 0px; padding: 0px;"></td>
                            <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                        </tr>
                    </table>';

                    $pdf->SetXY(4.5 + $x, 93.5 + $y);
                    $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                    /* --- GENERACION DE PDF --- */

                    $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                    //$fullpath = $_SERVER['DOCUMENT_ROOT'] . "/" . $nombre_archivo;
                    
                    $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";
                    
                    if (!is_dir($destinationFolder)) {
                        mkdir($destinationFolder, 0777, true);
                    }

                    $fullpath = $destinationFolder.$nombre_archivo;

                    /*
                    *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                    *D: send to the browser and force a file download with the name given by name.
                    *F: save to a local server file with the name given by name.
                    *S: return the document as a string. name is ignored.
                    *FI: equivalent to F + I option
                    *FD: equivalent to F + D option
                    */

                    //$docToSend = 1;

                    if ($docToSend == 0) {
                            $pdf->Output($nombre_archivo, 'I');
                    } else {
                            $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                            //$pdf->Output($nombre_archivo, 'I');

                            if ($infoDoc->correo != '') {
                                    $pdf->Output($fullpath, 'F');
                                    $docIntern = (int) $nControlP[3];
                                    $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                                    if (isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                                    if (isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                                    $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                                    switch($this->session->userdata('idaccount')) {
                                        case '1490796':
                                        case '4618':
                                        case '2585TIENDAS':
                                        //case '2815622':
                                        case '1708':
                                        case '3406536':
                                        case '2535420':
                                        case '2154998':
                                        case '776777':
                                        case '3338933':
                                        case '2539313':
                                        case '3317013':
                                        case '1492935':
                                            $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                                        break;
                                        default:
                                            $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                                    }

                                    if ($response == true) {
                                            $title = 'Correo Enviado';
                                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                                            $type = 'success';
                                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                                    } else {
                                            $title = 'Error de Envio';
                                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                                            $type = 'error';
                                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                                    }
                            } else {
                                    $title = 'Error de Envio';
                                    $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                                    $type = 'error';
                                    echo $this->closeTabFunction($title, $bodyMsg, $type);
                            }
                    }
            }
        }

        function notaCreditoElectronicBills($trannum, $idYear = 0, $docToSend = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 15, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3;
                $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach ($informacion as $info) {
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if (isset($resumen['tributos'])) $tributos  = $resumen['tributos']; else $tributos = array();
                if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';
                $nameVendedor = '';
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                $infoFact = $this->ventas_model->getDatosFactura($trannum);

                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                    $extension['observaciones'] = $info->notas;
                }

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = $sucursalInfo->telefono;
                    }
                }

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if (isset($emisor['tipoEstablecimiento'])) {
                    $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                }

                if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';
                if($this->session->userdata('idaccount') == '1937326') {
                    $imgHeader1Hght = '73px';
                }

                if($this->session->userdata('idaccount') == '90476') {
                    $imgHeader1Hght = '15px';
                    if ($idCentro == 2) {
                        $nameImagen = 'BostonLogo.png';
                    }
                }

                $fontSize = '9.5px';
                if($this->session->userdata('idaccount') == '1784550') {
                    $fontSize = '8.5px';
                }

                if ($this->session->userdata('idaccount') == '2922210') {
                    $header1 = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                        </tr>
                    </table>';
                } else {
                    $header1 = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                        </tr>';
                        if($this->session->userdata('idaccount') == '2585TIENDAS'){
                            $header1 .=
                                '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                </tr>';
                        }else{
                            $header1 .= 
                                '<tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                </tr>';
                        }
                        $header1 .= 
                        '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                        </tr>
                    </table>';
                }

                $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                $nControlP = explode('-', $identificacion['numeroControl']);

                $header2 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                    </tr>
                </table>';

                $qrCode = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D' . $identificacion['ambiente'] . '%26codGen%3D' . $identificacion['codigoGeneracion'] . '%26fechaEmi%3D' . $identificacion['fecEmi'] . '&size=79x79" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <br><br>
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['codigoGeneracion'] . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <br><br>
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $sRecepcion . '&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                    <br><br>
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['numeroControl'] . '&size=60x60" />
                            </td>
                    </tr>
                </table>';

                if (isset($direcReceptor)) {
                    $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                    $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                } else {
                    $receptorMun = array();
                    $receptorDep = array();
                }

                if (isset($direcRsujetoExcluido)) {
                    $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                    $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                } else {
                    $sujetoExcluidoMun = array();
                    $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if (isset($receptor['tipoDocumento'])) {
                    if ($receptor['tipoDocumento'] != '') {
                        $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                    }
                }

                $sujetoExcluidoDoc = array();
                if (isset($sujetoExcluido['tipoDocumento'])) {
                    if ($sujetoExcluido['tipoDocumento'] != '') {
                        $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                    }
                }

                if (!isset($receptorDoc['descrip'])) {
                    $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($sujetoExcluidoDoc['descrip'])) {
                    $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($receptor['nombreComercial'])) {
                    $receptor['nombreComercial'] = '';
                }

                if (!isset($direcReceptor['complemento'])) {
                    $direcReceptor['complemento'] = '';
                }

                if (!isset($direcRsujetoExcluido['complemento'])) {
                    $direcRsujetoExcluido['complemento'] = '';
                }

                if (!isset($receptor['correo'])) {
                    $receptor['correo'] = '';
                }

                $condicionPago = array();
                if (isset($resumen['condicionOperacion'])) {
                    if ($resumen['condicionOperacion'] != '') {
                        $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                    }
                } else {
                    $condicionPago['descrip'] = '';
                }

                if (!isset($extension['observaciones'])) {
                    $extension['observaciones'] = '';
                }

                if (!isset($extension['nombEntrega'])) {
                    $extension['nombEntrega'] = '';
                }

                if (!isset($extension['docuEntrega'])) {
                    $extension['docuEntrega'] = '';
                }

                if (!isset($extension['nombRecibe'])) {
                    $extension['nombRecibe'] = '';
                }

                if (!isset($extension['docuRecibe'])) {
                    $extension['docuRecibe'] = '';
                }

                $direcFontSize = '8px';
                    
                if (strlen($direcReceptor['complemento']) > 89) {
                    $direcFontSize = '7.5px';
                }

                $ordenString = '';
                if ($this->session->userdata('idaccount') == '291862') {
                    $ordenString = 'Orden:';
                } else {
                    $referenciaOT = '';
                }

                $header3 = '
                    <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Razon social:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">' . mb_substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64, 'UTF-8') . '</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">'. $ordenString .'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9.8px; width:16%;">'.trim($referenciaOT).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Act. económica:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">'.mb_substr(mb_strtoupper($receptor['descActividad'], 'UTF-8'), 0, 64, 'UTF-8').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NIT:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['nit'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Correo:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">'.substr($receptor['correo'], 0, 64).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">NRC:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['nrc'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Dirección:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$direcFontSize.'; width:59%;">'.mb_strtoupper($direcReceptor['complemento'], 'UTF-8').'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Teléfono:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['telefono'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">';
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $header3 .='
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Municipio:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">'.mb_substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64, 'UTF-8').'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                        break;
                    }
                    $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.mb_substr($condicionPago['descrip'], 0, 19, 'UTF-8').'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">';
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:13%;">Departamento:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:59%;">'.mb_substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64, 'UTF-8').'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';
                        break;
                    }
                $header3.= '</tr></table>';

                $header = '
                <table style="width:100%; margin:0; padding:0;">
                    <tr>
                            <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                            <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                    </tr>
                    <tr>
                            <td style="margin:0; padding:0;">' . $qrCode . '</td>
                    </tr>
                    <tr>
                            <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                    </tr>
                </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);

                $qrCodeLabel = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <p>Portal de Hacienda</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <p>Cód. Generación</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <p>Sello Recibido</p>
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                    <p>N° de Control</p>
                            </td>
                    </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 10.5 + $y);
                $pdf->writeHTML($header, true, false, true, false, '');

                $pdf->SetXY(86.5 + $x, 57 + $y);
                $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                /* --- INICIO SECCION PRODUCTOS --- */

                //$cuerpoDocumento2 = array();
                // for($i = 0; $i < 114; $i++){
                //     $cuerpoDocumento[$i] = $cuerpoDocumento[0];
                //     $cuerpoDocumento[$i]['numItem'] = $i;
                // }

                $cantLines = 0;
                $lineasPorProducto = 0;
                foreach($cuerpoDocumento as $body){
                    $lineasPorProducto = ceil(strlen($body['descripcion']) / 57);
                    $cantLines += $lineasPorProducto;
                }

                if ($cantLines <= 40) {
                    $cantPages = 1;
                } elseif ($cantLines > 40 && $cantLines <= 113) {
                    $cantPages = 2;
                } else {
                    $cantPages = (ceil(abs($cantLines - 113) / 65)) + 2;
                }

                $numProd = 0;
                $maxlines = 40;

                $docLines = count($cuerpoDocumento);
                if ($docLines <= 40) {
                    $maxlines = 40;
                } else {
                    if ($docLines > 40 && $docLines <= 113) {
                        if ($docLines <= 44) {
                            $maxlines = 40;
                        } else {
                            $maxlines = 48;
                        }
                    } else if ($docLines > 113) {
                        $maxlines = 48;
                    }
                }

                $stop_index = $maxlines;
                $aux2 = 1;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $invexento = 0;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0; //linea echa para poder visualizar el pdf
                $ivaCesc = 0;
                $cesc = 0;
                $lineasOcupa = 0;
                $totalDesc = 0;
                $discount = 0;

                $bodyDoc = '
                <table style="width:100%; padding:0px;">
                <thead>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:4.5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No. Item</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5.5%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cant.</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Modelo</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:46%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:8%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas no sujetas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Ventas exentas $</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas gravadas $</th>
                    </tr>
                </thead>';

            $modelosPorCodigo = array();
            foreach ($productos as $producto) {
                //var_dump($producto);
                $modelosPorCodigo[$producto->idproducto] = $producto->modelo;
            }           
                foreach($cuerpoDocumento as $body){
                    //if($numProd < $maxlines){
                    $codigo = $body['codigo'];
                    $proModelo = isset($modelosPorCodigo[$codigo]) ? $modelosPorCodigo[$codigo] : '';
                        $ventaNosj = number_format(floatval($body['ventaNoSuj']), 4, '.', ',');
                        $ventaExenta = number_format(floatval($body['ventaExenta']), 4, '.', ',');
                        if($ventaNosj == '0'){
                            $ventaNosj = '';
                        }
                        if($ventaExenta == '0'){
                            $ventaExenta = '';
                        }

                        if ($numProd >= $stop_index) {
                            $breakValue = 'always';
                            $numProd = 0;
                            $aux2++;
                        } else {
                            $breakValue = 'avoid';
                        }

                        $wrapped = wordwrap(trim(mb_strtoupper($body['descripcion'],'UTF-8')), 57, '<br>');

                        $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:4.5%;">'.$body['numItem'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5.5%;">'.$body['cantidad'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.$proModelo.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:45%;">'.$wrapped.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.number_format($body['precioUni'], 6, '.', ',').'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:8%;">'.$ventaNosj.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.$ventaExenta.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.number_format(floatval($body['ventaGravada']), 4, '.', ',').'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                        </tr>';

                        if ($aux2 > 1 && $aux2 <= $cantPages) {
                            $stop_index = 65;
                        }

                        $totalDesc = 0;
                        $numProd += ceil(strlen($body['descripcion']) / 57);
                        //$numProd++;
                    //}
                }
            

                if ($cantPages > 1) {
                    $maxlines = 65;
                }

                for ($i = $numProd; $i < $maxlines; $i++) {
                    $bodyDoc .='
                    <tr>
                        <td style="font-size: 9px; text-align:center; width:100%;"></td>
                    </tr>';
                }
                //$bodyDoc .='</table>';

                //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                        <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">'.trim($resumen['totalLetras']).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">'.substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 40).'</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.$extension['docuEntrega'].'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%;">Nombre recibe</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:41%;">'.substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 40).'</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:18%;">No Documento</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.$extension['docuRecibe'].'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                                </tr>';
                    if($extension['observaciones'] == ''){
                        $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                                </tr>';
                    }else if(strlen(trim($extension['observaciones'])) <= 86){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">'.trim($extension['observaciones']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    }else if(strlen(trim($extension['observaciones'])) > 86 && strlen(trim($extension['observaciones'])) <= 172){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">'.trim($extension['observaciones']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    }else if(strlen(trim($extension['observaciones'])) > 172 && strlen(trim($extension['observaciones'])) <= 258){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">'.trim($extension['observaciones']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    }else if(strlen(trim($extension['observaciones'])) > 258 && strlen(trim($extension['observaciones'])) <= 344){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">'.trim($extension['observaciones']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    }else{
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 0, 430).'</td>
                            </tr>';
                    }

                $extention .= '</table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:29%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Sumas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">$</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalNoSuj'], 2, '.', ',').'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalExenta'],2 ,'.', ',').'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalGravada'],2 ,'.', ',').'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Suma total de operaciones</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['subTotalVentas'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas no sujetas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['descuNoSuj'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas exentas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['descuExenta'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Rebajas y otras ventas gravadas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['descuGravada'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>';
                foreach($tributos as $trib){
                    $totals .= '<tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">'.$trib["descripcion"].'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($trib["valor"], 2, '.', ',').'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                            </tr>';
                }
                $totals .='
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Sub-total</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['subTotal'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Percibido</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['ivaPerci1'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">IVA Retenido</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['ivaRete1'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['montoTotalOperacion'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:4%; border-bottom: 0.1px solid #000;">$</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">'.number_format($resumen['montoTotalOperacion'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .= '
                    <tr style="width:100%; margin: 0px; padding: 0px;">
                            <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                            <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                    </tr>
                    <tr style="width:100%;">
                            <td style="width:1%; margin: 0px; padding: 0px;"></td>
                            <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                    </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                /* --- GENERACION DE PDF --- */

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                //$fullpath = $_SERVER['DOCUMENT_ROOT'] . "/" . $nombre_archivo;

                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";
                    
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                        *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                        *D: send to the browser and force a file download with the name given by name.
                        *F: save to a local server file with the name given by name.
                        *S: return the document as a string. name is ignored.
                        *FI: equivalent to F + I option
                        *FD: equivalent to F + D option
                */

                //$docToSend = 1;

                if ($docToSend == 0) {
                    $pdf->Output($nombre_archivo, 'I');
                } else {
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if ($infoDoc->correo != '') {
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                        if (isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if (isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                        switch($this->session->userdata('idaccount')) {
                            case '1490796':
                            case '4618':
                            case '2585TIENDAS':
                            //case '2815622':
                            case '1708':
                            case '3406536':
                            case '2535420':
                            case '2154998':
                            case '776777':
                            case '3338933':
                            case '2539313':
                            case '3317013':
                            case '1492935':
                                $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                            break;
                            default:
                                $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        }

                        if ($response == true) {
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        } else {
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    } else {
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            }
        }

        function facturaExportacionElectronicBills($trannum, $idYear = 0, $docToSend = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 15, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3;
                $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach ($informacion as $info) {
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if (isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if (isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if (isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if (isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if (isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if (isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if (isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if (isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if (isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if (isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if (isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if (isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                if (isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if (isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';
                $nameVendedor = '';
                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                $infoFact = $this->ventas_model->getDatosFactura($trannum);

                foreach ($infoFact as $info) {
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                    $resumen['observaciones'] = $info->notas;
                }

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'], 'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'], 'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'], 'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = $sucursalInfo->telefono;
                    }
                }

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if (isset($emisor['tipoEstablecimiento'])) {
                    $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'], 'CAT-009');
                }

                if (!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $fontSize = '9.5px';
                if($this->session->userdata('idaccount') == '1784550') {
                    $fontSize = '8.5px';
                }

                if($this->session->userdata('idaccount') == '90476') {
                    //$imgHeader1Hght = '15px';
                    if ($idCentro == 2) {
                        $nameImagen = 'BostonLogo.png';
                    }
                }

                if ($this->session->userdata('idaccount') == '2922210') {
                    $header1 = '
                                                                <table style="width:100%; padding:0px;">
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                                                                        </tr>
                                                                        <tr style="width:100%; padding:0px;">
                                                                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                                                                        </tr>';
                    $header1 .= '</table>';
                } else {
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                                <tr style="width:100%; padding:0px;">
                                        <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: 20px;"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">' . substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">' . substr(mb_strtoupper($direcEmisor['complemento']), 0, 112) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. ' . substr($emisor['telefono'] . ' Sucursal: ' . $nameSucursal, 0, 44) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">' . substr($emisor['correo'], 0, 56) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: ' . substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: ' . substr($emisor['nit'], 0, 19) . '</td>
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: ' . substr($emisor['nrc'], 0, 19) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: ' . substr($nameVendedor, 0, 40) . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: ' . $trannum . '</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Recinto Fiscal: '.substr($emisor['recintoFiscal'], 0, 35).'</td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Regimen de Exportación: '.substr($emisor['regimen'], 0, 32).'</td>
                                </tr>';
                    $header1 .= '</table>';
                }

                $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">' . mb_strtoupper($tipoDoc['descrip'], 'UTF-8') . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['codigoGeneracion'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $sRecepcion . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">' . $identificacion['numeroControl'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . $identificacion['version'] . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . ucfirst($tipoTransmision[array_key_last($tipoTransmision)]) . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . date_format(date_create($identificacion['fecEmi']), "d/m/Y") . '</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">' . date_format(date_create($identificacion['horEmi']), "h:i:s A") . '</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                $nControlP = explode('-', $identificacion['numeroControl']);

                $header2 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">' . (int) $nControlP[3] . '</td>
                    </tr>
                </table>';

                $qrCode = '
                <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D' . $identificacion['ambiente'] . '%26codGen%3D' . $identificacion['codigoGeneracion'] . '%26fechaEmi%3D' . $identificacion['fecEmi'] . '&size=79x79" />
                                </td>
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <br><br>
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['codigoGeneracion'] . '&size=60x60" />
                                </td>
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <br><br>
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $sRecepcion . '&size=60x60" />
                                </td>
                                <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                        <br><br>
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . $identificacion['numeroControl'] . '&size=60x60" />
                                </td>
                        </tr>
                </table>';

                if (isset($direcReceptor)) {
                    $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'], $direcReceptor['departamento']);
                    $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                } else {
                    $receptorMun = array();
                    $receptorDep = array();
                }

                if (isset($direcRsujetoExcluido)) {
                    $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'], $direcRsujetoExcluido['departamento']);
                    $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                } else {
                    $sujetoExcluidoMun = array();
                    $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if (isset($receptor['tipoDocumento'])) {
                    if ($receptor['tipoDocumento'] != '') {
                        $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'], 'CAT-022');
                    }
                }

                $sujetoExcluidoDoc = array();
                if (isset($sujetoExcluido['tipoDocumento'])) {
                    if ($sujetoExcluido['tipoDocumento'] != '') {
                        $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'], 'CAT-022');
                    }
                }

                if (!isset($receptorDoc['descrip'])) {
                    $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($sujetoExcluidoDoc['descrip'])) {
                    $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if (!isset($receptor['nombreComercial'])) {
                    $receptor['nombreComercial'] = '';
                }

                if (!isset($direcReceptor['complemento'])) {
                    $direcReceptor['complemento'] = '';
                }

                if (!isset($direcRsujetoExcluido['complemento'])) {
                    $direcRsujetoExcluido['complemento'] = '';
                }

                if (!isset($receptor['correo'])) {
                    $receptor['correo'] = '';
                }

                $condicionPago = array();
                if (isset($resumen['condicionOperacion'])) {
                    if ($resumen['condicionOperacion'] != '') {
                        $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'], 'CAT-016');
                    }
                } else {
                    $condicionPago['descrip'] = '';
                }

                if (!isset($extension['observaciones'])) {
                    $extension['observaciones'] = '';
                }

                if (!isset($extension['nombEntrega'])) {
                    $extension['nombEntrega'] = '';
                }

                if (!isset($extension['docuEntrega'])) {
                    $extension['docuEntrega'] = '';
                }

                if (!isset($extension['nombRecibe'])) {
                    $extension['nombRecibe'] = '';
                }

                if (!isset($extension['docuRecibe'])) {
                    $extension['docuRecibe'] = '';
                }

                $ordenString = '';
                if ($this->session->userdata('idaccount') == '291862') {
                    $ordenString = 'Orden:';
                } else {
                    $referenciaOT = '';
                }

                $header3 = '
                    <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$ordenString.'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.$referenciaOT.'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$receptorDoc['descrip'].':</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['numDocumento'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Act. Económica:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr($receptor['descActividad'], 0, 64).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">País destino:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['nombrePais'], 0, 19).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.mb_substr(mb_strtoupper($receptor['complemento'], 'UTF-8'), 0, 64, 'UTF-8').'</td>
                        </tr>
                    </table>';

                $header = '
                <table style="width:100%; margin:0; padding:0;">
                    <tr>
                            <td rowspan="2" style="width: 40%;">' . $header1 . '</td>
                            <td style="margin:0; padding:0; width: 60%;">' . $header2 . '</td>
                    </tr>
                    <tr>
                            <td style="margin:0; padding:0;">' . $qrCode . '</td>
                    </tr>
                    <tr>
                            <td colspan="2" style="margin:0; padding:0;">' . $header3 . '</td>
                    </tr>
                </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);

                $qrCodeLabel = '
                <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <p>Portal de Hacienda</p>
                                </td>
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <p>Cód. Generación</p>
                                </td>
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <p>Sello Recibido</p>
                                </td>
                                <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                        <p>N° de Control</p>
                                </td>
                        </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 10.5 + $y);
                $pdf->writeHTML($header, true, false, true, false, '');

                $pdf->SetXY(86.5 + $x, 57 + $y);
                $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO CREDITO FISCAL
                /* --- INICIO SECCION PRODUCTOS --- */

                //$cuerpoDocumento2 = array();
                // for($i = 0; $i < 94; $i++){
                //     $cuerpoDocumento[$i] = $cuerpoDocumento[0];
                //     $cuerpoDocumento[$i]['numItem'] = $i;
                // }

                $cantLines = 0;
                $lineasPorProducto = 0;
                foreach($cuerpoDocumento as $body){
                    $lineasPorProducto = ceil(strlen($body['descripcion']) / 68);
                    $cantLines += $lineasPorProducto;
                }

                if ($cantLines <= 42) {
                    $cantPages = 1;
                } elseif ($cantLines > 42 && $cantLines <= 115) {
                    $cantPages = 2;
                } else {
                    $cantPages = (ceil(abs($cantLines - 116) / 68)) + 2;
                }

                $numProd = 0;
                $maxlines = 42;

                $docLines = count($cuerpoDocumento);
                if ($docLines <= 42) {
                    $maxlines = 42;
                } else {
                    if ($docLines > 42 && $docLines <= 116) {
                        if ($docLines <= 46) {
                            $maxlines = 42;
                        } else {
                            $maxlines = 50;
                        }
                    } else if ($docLines > 116) {
                        $maxlines = 50;
                    }
                }

                $stop_index = $maxlines;
                $aux2 = 1;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                //$invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $invexento = 0;
                $vnExenta = 0;
                $vnGravada = 0;
                $numProd = 0; //linea echa para poder visualizar el pdf
                $ivaCesc = 0;
                $cesc = 0;
                $lineasOcupa = 0;
                $totalDesc = 0;
                $discount = 0;

                $bodyDoc = '
                <table style="width:100%; padding:0px;">
                <thead>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">CUERPO DEL DOCUMENTO</th>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:5%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; background-color: #CFCFCF;">No°</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:6%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Cantidad</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:7%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Modelo</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:54%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Descripción</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Precio<br>unitario</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:10%; border-bottom: 0.1px solid #000; background-color: #CFCFCF;">Otros Montos no Afectos</th>
                        <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 9px; width:9%; border-bottom: 0.1px solid #000; background-color: #CFCFCF; border-right: 0.1px solid #000; background-color: #CFCFCF;">Ventas Afectas</th>
                    </tr>
                </thead>';

                $modelosPorCodigo = array();
                foreach ($productos as $producto) {
                    //var_dump($producto);
                    $modelosPorCodigo[$producto->idproducto] = $producto->modelo;
                }  

                foreach($cuerpoDocumento as $body){
                    //if($numProd < $maxlines){
                    $codigo = $body['codigo'];
                    $proModelo = isset($modelosPorCodigo[$codigo]) ? $modelosPorCodigo[$codigo] : '';
                        $montoDescu = number_format(floatval($body['montoDescu']), 2, '.', ',');
                        $noGravado = number_format(floatval($body['noGravado']), 2, '.', ',');
                        if($montoDescu == '0'){
                            $montoDescu = '';
                        }
                        if($noGravado == '0'){
                            $noGravado = '';
                        }

                        if ($numProd >= $stop_index) {
                            $breakValue = 'always';
                            $numProd = 0;
                            $aux2++;
                        } else {
                            $breakValue = 'avoid';
                        }

                        $wrapped = wordwrap(trim(mb_strtoupper($body['descripcion'],'UTF-8')), 68, '<br>');

                        $bodyDoc .= '<tr style="width:100%; padding:0px; page-break-before: ' . $breakValue . ';">
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:5%;">'.$body['numItem'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:6%;">'.$body['cantidad'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:7%;">'.$proModelo.'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:53%;">'.trim(mb_strtoupper($body['descripcion'],'UTF-8')).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.number_format($body['precioUni'], 2, '.', ',').'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:10%;">'.$noGravado.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:9%;">'.number_format(floatval($body['ventaGravada']), 2, '.', ',').'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:1%;"></td>
                        </tr>';

                        if ($aux2 > 1 && $aux2 <= $cantPages) {
                            $stop_index = 68;
                        }

                        $totalDesc = 0;
                        $numProd += ceil(strlen($body['descripcion']) / 68);
                    //}
                }

                if ($cantPages > 1) {
                    $maxlines = 68;
                }

                for ($i = $numProd; $i < $maxlines; $i++) {
                    $bodyDoc .= '
                    <tr>
                        <td style="font-size: 9px; text-align:center; width:100%;"></td>
                    </tr>';
                }
                //$bodyDoc .='</table>';

                //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                    <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-top: 0.1px solid #000;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:80%; border-top: 0.1px solid #000;">'.trim($resumen['totalLetras']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">EXTENSIÓN</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:30%;">Condición de la Operación</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:69%;">'.substr(mb_strtoupper($condicionPago['descrip'], 'UTF-8'), 0, 35).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:25%;">Descripción Incoterms</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:74%;">'.substr(mb_strtoupper($resumen['descIncoterms'], 'UTF-8'), 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000; background-color: #CFCFCF;">OBSERVACIONES</td>
                            </tr>';
                    if($resumen['observaciones'] == ''){
                        $extention .= '
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%;"></td>
                                </tr>
                                <tr style="width:100%; padding:0px;">
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                                </tr>';
                    }else if(strlen(trim($resumen['observaciones'])) <= 86){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%;">'.trim($resumen['observaciones']).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border-bottom: 0.1px solid #000;"></td>
                            </tr>';
                    }else if(strlen(trim($resumen['observaciones'])) > 86 && strlen(trim($resumen['observaciones'])) <= 172){
                        $extention .= '
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:1%; border-bottom: 0.1px solid #000;"></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:99%; border-bottom: 0.1px solid #000;">'.substr(trim($resumen['observaciones']), 0, 172).'</td>
                            </tr>';
                    }

                $extention .= '
                </table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; border-left: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%; border-top: 0.1px solid #000;">Total de Operaciones Afectas</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%; border-top: 0.1px solid #000;">'.number_format($resumen['montoTotalOperacion'], 2, '.', ',').'</td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-top: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto Global de Descuento</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['totalDescu'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Seguro</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['seguro'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Flete</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['flete'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Monto total de la operación</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;">'.number_format($resumen['totalPagar'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:70%;">Total otros montos no afectos</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:20%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 9px; width:70%; border-bottom: 0.1px solid #000;">TOTAL A PAGAR</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:20%; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalPagar'], 2, '.', ',').'</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:2%; border-bottom: 0.1px solid #000;"></td>
                    </tr>
                </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .= '
                        <tr style="width:100%; margin: 0px; padding: 0px;">
                                <td style="width:60%; margin: 0px; padding: 0px; text-align: left;">' . $extention . '</td>
                                <td style="width:40%; margin: 0px; padding: 0px; text-align: left;">' . $totals . '</td>
                        </tr>
                        <tr style="width:100%;">
                                <td style="width:1%; margin: 0px; padding: 0px;"></td>
                                <td style="width:99%; margin: 0px; padding: 0px;">' . $message . '</td>
                        </tr>
                </table>';

                $pdf->SetXY(4.5 + $x, 93.5 + $y);
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                // FIN CUERPO DE DOCUMENTO CREDITO FISCAL

                /* --- GENERACION DE PDF --- */

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'] . '.pdf');
                //$fullpath = $_SERVER['DOCUMENT_ROOT'] . "/" . $nombre_archivo;

                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";
                    
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                        *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                        *D: send to the browser and force a file download with the name given by name.
                        *F: save to a local server file with the name given by name.
                        *S: return the document as a string. name is ignored.
                        *FI: equivalent to F + I option
                        *FD: equivalent to F + D option
                */

                //$docToSend = 1;

                if ($docToSend == 0) {
                    $pdf->Output($nombre_archivo, 'I');
                } else {
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if ($infoDoc->correo != '') {
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']), "d/m/Y");

                        if (isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if (isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                        switch($this->session->userdata('idaccount')) {
                            case '1490796':
                            case '4618':
                            case '2585TIENDAS':
                            //case '2815622':
                            case '1708':
                            case '3406536':
                            case '2535420':
                            case '2154998':
                            case '776777':
                            case '3338933':
                            case '2539313':
                            case '3317013':
                            case '1492935':
                                $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                            break;
                            default:
                                $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        }

                        if ($response == true) {
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        } else {
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    } else {
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            }
        }

        function facturaConsumidorFinalElectronicBills($trannum, $idYear = 0, $docToSend = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Documento Tributario Electrónico');
                $pdf->SetSubject('Documento Tributario Electrónico');
                $pdf->SetMargins(7.5, 10.5, 9, true);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetAutoPageBreak(TRUE, 7);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('helvetica', '', 7.5, '', true);
                $pdf->addPage('P', 'LETTER');

                $x = 3; $y = 3;

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach($informacion as $info){
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if(isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if(isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if(isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if(isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if(isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if(isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if(isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if(isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if(isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if(isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if(isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if(isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                if(isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if(isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';
                $nameVendedor = '';

                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');
                $infoFact = $this->ventas_model->getDatosFactura($trannum);
                foreach($infoFact as $info){
                    $idClase = $info->idclase;
                    $nameSucursal = $info->nameSucursal;
                    $nameVendedor = $info->nameVendedor;
                    $extension['observaciones'] = $info->notas;
                    $diasCredito = $info->dias.' dias';
                    $referenciaOT = $info->referencia;
                    $idCliente = (int) $info->idcliente;
                    $idCentro = (int) $info->idcentro;
                }

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$idCentro, 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$idCentro);
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'],'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'],'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'],'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = $sucursalInfo->telefono;
                    }
                }

                /* --- INICIO SECCION CABECERAS --- */
                $emisorEstab = array();
                if(isset($emisor['tipoEstablecimiento'])){
                    $emisorEstab = $this->dte_model->getDescripCodigoDTE($emisor['tipoEstablecimiento'],'CAT-009');
                }

                if(!isset($emisorEstab['descrip'])) $emisorEstab['descrip'] = '';

                $imgHeader1Hght = '20px';
                $fontSize = '9.5px';

                if($this->session->userdata('idaccount') == '1937326') {
                    $imgHeader1Hght = '63px';
                }

                if($this->session->userdata('idaccount') == '90476') {
                    $imgHeader1Hght = '15px';
                    if ($idCentro == 2) {
                        $nameImagen = 'BostonLogo.png';
                    }
                }

                if($this->session->userdata('idaccount') == '1784550') {
                    $fontSize = '8.5px';
                }

                if($this->session->userdata('idaccount') == '2922210'){
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 25px;"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; text-decoration: underline;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucwords(strtolower($direcEmisor['complemento'])), 0, 112).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; line-height: 49px;"></td>
                            </tr>';
                        $header1 .= '</table>';
                } else{
                    $header1 = '
                        <table style="width:100%; padding:0px;">
                            <tr style="width:100%; padding:0px;">
                                <td style="padding:0px;margin:0px;width:100%; text-align:left; line-height: '.$imgHeader1Hght.';"><img style="max-width: 100%; display: block; width: auto; height: 83px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:100%;">'.substr(mb_strtoupper($razonSocial, 'UTF-8'), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr(ucfirst(strtolower($emisor['descActividad'])), 0, 56).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: '.$fontSize.'; width:100%;">'.substr(mb_strtoupper($direcEmisor['complemento']), 0, 112).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tel. '.substr($emisor['telefono'].' Sucursal: '.$nameSucursal, 0, 44).'</td>
                            </tr>';
                            if($this->session->userdata('idaccount') == '2585TIENDAS'){
                                $header1 .=
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">facturacionelectronica@laiberica.net</td>
                                    </tr>';

                            }else{
                                $header1 .= 
                                    '<tr style="width:100%; padding:0px;">
                                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.substr($emisor['correo'], 0, 56).'</td>
                                    </tr>';
                            }
                        $header1 .=
                            '<tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Tipo Establecimiento: '.substr(ucwords(mb_strtolower($emisorEstab['descrip'], 'UTF-8')), 0, 34).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NIT: '.substr($emisor['nit'], 0, 19).'</td>
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">NRC: '.substr($emisor['nrc'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">Vendedor: '.substr($nameVendedor, 0, 40).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%;">N° de Control Interno: '.$trannum.'</td>
                            </tr>';
                        $header1 .= '</table>';
                }

                $header2 = '
                <table style="width:100%; padding:0px; border: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; width:100%; border-top: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">DOCUMENTO TRIBUTARIO ELECTRÓNICO</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 13px; width:100%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000; border-right: 0.1px solid #000; background-color: #CFCFCF;">'.mb_strtoupper($tipoDoc['descrip'],'UTF-8').'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Código generacion:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$identificacion['codigoGeneracion'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Sello de recepción:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$sRecepcion.'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Número de control:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:71%;">'.$identificacion['numeroControl'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Modélo facturación:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.ucfirst($modeloFacturacion[array_key_last($modeloFacturacion)]).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Versión del Json:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.$identificacion['version'].'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Tipo de transmisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.ucfirst($tipoTransmision[array_key_last($tipoTransmision)]).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Fecha emisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.date_format(date_create($identificacion['fecEmi']),"d/m/Y").'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:27%;">Hora de emisión:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">'.date_format(date_create($identificacion['horEmi']),"h:i:s A").'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>';

                        $nControlP = explode('-', $identificacion['numeroControl']);

                    $header2 .= '
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:30%;">Documento interno No:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18%;">'.(int) $nControlP[3].'</td>
                        </tr>';
                $header2 .= '</table>';

                $qrCode = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:center; vertical-align: top; padding:0px; margin:0px; width:25%;">
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data=https%3A%2F%2Fadmin.factura.gob.sv%2FconsultaPublica%3Fambiente%3D'.$identificacion['ambiente'].'%26codGen%3D'.$identificacion['codigoGeneracion'].'%26fechaEmi%3D'.$identificacion['fecEmi'].'&size=79x79" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['codigoGeneracion'].'&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$sRecepcion.'&size=60x60" />
                            </td>
                            <td style="text-align:center; vertical-align: bottom; padding:0px; margin:0px; width:25%;">
                                <br><br>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?data='.$identificacion['numeroControl'].'&size=60x60" />
                            </td>
                        </tr>
                    </table>';

                if(isset($direcReceptor)){
                    $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'],$direcReceptor['departamento']);
                    $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                }else{
                    $receptorMun = array();
                    $receptorDep = array();
                }

                if(isset($direcRsujetoExcluido)){
                    $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'],$direcRsujetoExcluido['departamento']);
                    $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                }else{
                    $sujetoExcluidoMun = array();
                    $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if(isset($receptor['tipoDocumento'])){
                    if($receptor['tipoDocumento'] != ''){
                        $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'],'CAT-022');
                    }
                }

                $sujetoExcluidoDoc = array();
                if(isset($sujetoExcluido['tipoDocumento'])){
                    if($sujetoExcluido['tipoDocumento'] != ''){
                        $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'],'CAT-022');
                    }
                }

                if(!isset($receptorDoc['descrip'])){
                    $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($receptor['numDocumento'])){
                    $receptor['numDocumento'] = '';
                }

                if(!isset($sujetoExcluidoDoc['descrip'])){
                    $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($receptor['nombreComercial'])){
                    $receptor['nombreComercial'] = '';
                }

                if(!isset($receptor['nit'])){
                    $receptor['nit'] = '';
                }

                if(!isset($direcReceptor['complemento'])){
                    $direcReceptor['complemento'] = '';
                }

                if(!isset($direcRsujetoExcluido['complemento'])){
                    $direcRsujetoExcluido['complemento'] = '';
                }

                if(!isset($receptor['correo'])){
                    $receptor['correo'] = '';
                }

                $condicionPago = array();
                if(isset($resumen['condicionOperacion'])){
                    if($resumen['condicionOperacion'] != ''){
                        $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'],'CAT-016');
                    }
                }else{
                    $condicionPago['descrip'] = '';
                }

                if(!isset($extension['observaciones'])){
                    $extension['observaciones'] = '';
                }

                if(!isset($extension['nombEntrega'])){
                    $extension['nombEntrega'] = '';
                }

                if(!isset($extension['docuEntrega'])){
                    $extension['docuEntrega'] = '';
                }

                if(!isset($extension['nombRecibe'])){
                    $extension['nombRecibe'] = '';
                }

                if(!isset($extension['docuRecibe'])){
                    $extension['docuRecibe'] = '';
                }

                $ordenString = '';
                if ($this->session->userdata('idaccount') == '291862') {
                    $ordenString = 'Orden:';
                } else {
                    $referenciaOT = '';
                }

                $header3 = '
                <table style="width:100%; padding:0px; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Razon social:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombre'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$ordenString.'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.$referenciaOT.'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Nombre Comercial:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($receptor['nombreComercial'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.$receptorDoc['descrip'].':</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['numDocumento'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Correo:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr($receptor['correo'], 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">NRC:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['nrc'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Dirección:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:54%;">'.mb_strtoupper($direcReceptor['complemento'], 'UTF-8').'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Teléfono:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($receptor['telefono'], 0, 19).'</td>
                    </tr>
                    <tr style="width:100%; padding:0px;">';
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Municipio:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($muni['municipio'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                        break;
                    }
                        if($this->session->userdata('idaccount') == '2922210'){
                            $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;"> &nbsp; &nbsp; &nbsp; &nbsp;'.substr($condicionPago['descrip'], 0, 19).' '.$diasCredito.'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';
                        }else{
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Forma pago:</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr($condicionPago['descrip'], 0, 19).'</td>
                            </tr>
                            <tr style="width:100%; padding:0px;">';}
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:15%;">Departamento:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:54%;">'.substr(mb_strtoupper($depto['depto'], 'UTF-8'), 0, 64).'</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:1%;"></td>';
                        break;
                    }
                        $header3 .= '<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Moneda:</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:16%;">'.substr(mb_strtoupper($identificacion['tipoMoneda'], 'UTF-8'), 0, 19).'</td>
                    </tr>
                </table>';

                $header = '<table style="width:100%; margin:0; padding:0;">
                        <tr>
                            <td rowspan="2" style="width: 40%;">'.$header1.'</td>
                            <td style="margin:0; padding:0; width: 60%;">'.$header2.'</td>
                        </tr>
                        <tr>
                            <td style="margin:0; padding:0;">'.$qrCode.'</td>
                        </tr>
                        <tr>
                            <td style="margin:0; padding:0; line-height: 2px;"></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="margin:0; padding:0;">'.$header3.'</td>
                        </tr>
                    </table>';

                //$pdf->setPrintHeader(true);
                //$pdf->setHTMLHeader($header);
                
                $qrCodeLabel = '
                <table style="width:100%; padding:0px;">
                    <tr style="width:100%; padding:0px;">
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Portal de Hacienda</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Cód. Generación</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>Sello Recibido</p>
                        </td>
                        <td style="text-align:center; vertical-align: middle; padding:0px; margin:0px; width:25%;">
                            <p>N° de Control</p>
                        </td>
                    </tr>
                </table>';

                $pdf->SetXY( 4.5 + $x, 10.5 + $y );
                $pdf->writeHTML($header, true, false, true, false, '');

                $pdf->SetXY( 86.5 + $x, 56 + $y );
                $pdf->writeHTML($qrCodeLabel, true, false, true, false, '');

                /* --- FIN SECCION CABECERAS --- */

                //INICIO CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL
                    /* --- INICIO SECCION PRODUCTOS --- */

                    // for($i = 0; $i < 258; $i++){
                    //     $cuerpoDocumento[$i] = $cuerpoDocumento[0];
                    // }

                    $cantLines = 0;
                    $lineasPorProducto = 0;
                    foreach($cuerpoDocumento as $body){
                        $lineasPorProducto = ceil(strlen($body['descripcion']) / 65);
                        $cantLines += $lineasPorProducto;
                    }

                    if ($cantLines <= 32) {
                        $cantPages = 1;
                    } elseif ($cantLines > 32 && $cantLines <= 101) {
                        $cantPages = 2;
                    } else {
                        $cantPages = (ceil(abs($cantLines - 101) / 63)) + 2;
                    }

                    $numProd = 0;
                    $maxlines = 32;

                    if ($cantLines <= 32) {
                        $maxlines = 32;
                    } else {
                        if ($cantLines > 32 && $cantLines <= 101) {
                            if ($cantLines <= 40) {
                                $maxlines = 32;
                            } else {
                                $maxlines = 44;
                            }
                        } else if ($cantLines > 101) {
                            $maxlines = 44;
                        }
                    }

                    $productos = $this->invtran_model->getDataTran100k($trannum);

                    $stop_index = $maxlines;
                    $aux2 = 1;

                    $bodyDoc = '
                    <table style="width: 100%; padding: 0.5px;">
                    <thead>
                        <tr style="width: 100%;">
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width: 5.8%; border-left: 0.1px solid #000; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">LINEA</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width: 9.4%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">MODELO</th>
                            <th style="text-align:  left; vertical-align: middle; font-weight: bold; font-size: 8px; width:46.8%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">DESCRIPCIÓN</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width: 7.8%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; ">CANTIDAD</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 8px; width:   9%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">PRECIO UNIT</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 8%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">VTAS.NO SUJETAS</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 6%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">VTAS. EXENTAS</th>
                            <th style="text-align:center; vertical-align: middle; font-weight: bold; font-size: 6.5px; width: 8%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">VTAS. GRAVADAS</th>
                        </tr>
                    </thead>';

                    $modelosPorCodigo = array();
                    foreach ($productos as $producto) {
                        $modelosPorCodigo[$producto->idproducto] = $producto->modelo;
                    } 

                    foreach($cuerpoDocumento as $body){
                    //foreach($cuerpoDocumento2 as $body){
                        //if($numProd < $maxlines){
                        $codigo = $body['codigo'];
                        $proModelo = isset($modelosPorCodigo[$codigo]) ? $modelosPorCodigo[$codigo] : '';
                            $ventaNosj = number_format(floatval($body['ventaNoSuj']), 2, '.', ',');
                            $ventaExenta = number_format(floatval($body['ventaExenta']), 2, '.', ',');
                            $ventaGravada = number_format(floatval($body['ventaGravada']), 2, '.', ',');
                            if($ventaNosj == '0'){
                                $ventaNosj = '';
                            }
                            if($ventaExenta == '0'){
                                $ventaExenta = '';
                            }

                            if($numProd >= $stop_index){
                                $breakValue = 'always';
                                $numProd = 0;
                                $aux2++;
                            }else{
                                $breakValue = 'avoid';
                            }

                            $wrapped = wordwrap(trim($body['descripcion']), 65, '<br>');

                            $bodyDoc .= '<tr style=" page-break-before: '.$breakValue.'; padding: 0px;">';
                                $bodyDoc .= '<td style="width: 5.8%; text-align: center;">'.$body['numItem'].'</td>';
                                $bodyDoc .= '<td style="width: 9.4%; text-align: center;">'.$proModelo.'</td>';
                                //$bodyDoc .= '<td style="width:55.4%; text-align: left; font-size:8.6px;">'.substr(trim($body['descripcion']),0, 70).'</td>';
                                $bodyDoc .= '<td style="width:46.8%; text-align: left; font-size:8.6px;">'.$wrapped.'</td>';
                                $bodyDoc .= '<td style="width: 7.8%; text-align: center;">'.$body['cantidad'].'</td>';
                                $bodyDoc .= '<td style="width:   9%; text-align:  right;">'.number_format($body['precioUni'], 4, '.', ',').'</td>';
                                $bodyDoc .= '<td style="width:   8%; text-align:  right;">'.$ventaNosj.'</td>';
                                $bodyDoc .= '<td style="width:   6%; text-align:  right;">'.$ventaExenta.'</td>';
                                $bodyDoc .= '<td style="width:   8%; text-align:  right;">'.$ventaGravada.'</td>';
                            $bodyDoc .= '</tr>';

                            if($aux2 > 1 && $aux2 <= $cantPages){
                                $stop_index = 56;
                            }

                            $numProd += ceil(strlen($body['descripcion']) / 65);
                            //var_dump($numProd);
                        //}
                    }

                    if($cantPages > 1){
                        $maxlines = 57;
                    }

                    for($i = $numProd; $i < $maxlines; $i++){
                        $bodyDoc .= '<tr style="padding: 0px;">
                            <td style="font-size:9px; text-align:center; width:100%;"></td>
                        </tr>';
                    }
                    //$bodyDoc .='</table>';

                    //$pdf->SetXY( 4.5 + $x, 93.5 + $y );
                    //$pdf->writeHTML($bodyDoc, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                /* --- INICIO SECCION EXTENSION --- */

                $extention = '
                    <table style="width:100%; padding:0px;">
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:19%; border-top: 0.1px solid #000;">Valor en letras:</td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-top: 0.1px solid #000; "></td>
                            <td style="line-height: 24.1px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:79%; border-top: 0.1px solid #000; border-right: 0.1px solid #000;">'.strtoupper($this->eliminarTildes(trim($resumen['totalLetras']))).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 17px; text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">EXTENSION</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">Nombre entrega:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:42%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.substr(mb_strtoupper($extension['nombEntrega'], 'UTF-8'), 0, 50).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">No Documento:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:21%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.$extension['docuEntrega'].'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-bottom: 0.1px solid #000;">Nombre recibe:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:42%; border-bottom: 0.1px solid #000;">'.substr(mb_strtoupper($extension['nombRecibe'], 'UTF-8'), 0, 50).'</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-bottom: 0.1px solid #000;">No Documento:</td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:21%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">'.$extension['docuRecibe'].'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="width:1%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:17%; border-bottom: 0.1px solid #000;">Firma:</td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:31.5%; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:18%; border-bottom: 0.1px solid #000; ">Firma:</td>
                            <td style="line-height: 34px; text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:31.5%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 17px; text-align:center; vertical-align:middle; font-weight: bold; font-size: 9px; width:100%; border: 0.1px solid #000;">OBSERVACIONES</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 0, 80).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 80, 80).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 160, 80).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 240, 80).'</td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8.5px; width:1%; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8.5px; width:99%; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;">'.substr(trim($extension['observaciones']), 320, 80).'</td>
                        </tr>
                    </table>';

                //$pdf->SetXY( 4.5, 210 );
                //$pdf->writeHTML($extention, true, false, true, false, '');

                /* --- INICIO SECCION TOTALES --- */

                $totals = '
                <table style="width:100%; padding:0px; ">
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:32.9%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Suma de Ventas:</td>
                        <td style="line-height: 24.1px;text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:15.2%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalNoSuj'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:23.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalExenta'],2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format(floatval($resumen['totalGravada']),2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sumatoria de Ventas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['subTotalVentas'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Vtas.Exentas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalExenta'],2 ,'.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>
                    <tr style="width:100%; padding:0px;">
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Vtas.No Sujetas:</td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                        <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalNoSuj'], 2, '.', ',').'</td>
                        <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                    </tr>';
                if(isset($tributos)){
                    foreach($tributos as $trib){
                        $totals .= '<tr style="width:100%; padding:0px;">
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">'.$trib["descripcion"].'</td>
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                                    <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($trib["valor"], 2, '.', ',').'</td>
                                    <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                                </tr>';
                    }
                }
                $totals .='
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Sub - Total:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['subTotal'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">IVA Retenido:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['ivaRete1'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                        <tr style="width:100%; padding:0px;">
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:72.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-left: 0.1px solid #000;">Total a Pagar:</td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.9%; border-top: 0.1px solid #000; border-right: 0.1px solid #000; border-bottom: 0.1px solid #000;"></td>
                            <td style="line-height: 24.1px; text-align:right; vertical-align:middle; font-weight: bold; font-size: 9px; width:26.5%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000;">'.number_format($resumen['totalPagar'], 2, '.', ',').'</td>
                            <td style="line-height: 24.1px; text-align:center; vertical-align:middle; font-weight: normal; font-size: 9px; width:0.3%; border-top: 0.1px solid #000; border-bottom: 0.1px solid #000; border-right: 0.1px solid #000;"></td>
                        </tr>
                    </table>';

                //$pdf->SetXY( 128.4, 210 );
                //$pdf->writeHTML($totals, true, false, true, false, '');

                /* --- FIN SECCION TOTALES --- */

                $message = '<p style="font-size: 9px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>';
                //$pdf->SetXY( 4.5, 265 );
                //$pdf->writeHTML($message, true, false, true, false, '');

                $bodyDoc .='
                    <tr style="width:100%;">
                        <td style="width:60%;">'.$extention.'</td>
                        <td style="width:40%;">'.$totals.'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:100%;">'.$message.'</td>
                    </tr>
                </table>';

                $pdf->SetXY( 4.5 + $x, 93.5 + $y );
                $pdf->writeHTML($bodyDoc, true, false, true, false, '');

                    /* --- FIN SECCION TOTALES --- */
                //FIN CUERPO DE DOCUMENTO FACTURA CONSUMIDOR FINAL

                /* --- GENERACION DE PDF --- */ 

                $nombre_archivo = utf8_decode($identificacion['codigoGeneracion'].'.pdf');
                //$fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo;

                $destinationFolder = rtrim($_SERVER['DOCUMENT_ROOT']."dte_files", '/') . "/";
                    
                if (!is_dir($destinationFolder)) {
                    mkdir($destinationFolder, 0777, true);
                }

                $fullpath = $destinationFolder.$nombre_archivo;

                /*
                    *I: send the file inline to the browser (default). The plug-in is used if available. The name given by name is used when one selects the “Save as” option on the link generating the PDF.
                    *D: send to the browser and force a file download with the name given by name.
                    *F: save to a local server file with the name given by name.
                    *S: return the document as a string. name is ignored.
                    *FI: equivalent to F + I option
                    *FD: equivalent to F + D option
                 */

                //$docToSend = 1;
                
                if($docToSend == 0){
                    $pdf->Output($nombre_archivo, 'I');
                }else{
                    $infoDoc = $this->dev_model->getCorreoFacturacionJSON($trannum, $idYear);
                    //$pdf->Output($nombre_archivo, 'I');

                    if($infoDoc->correo != ''){
                        $pdf->Output($fullpath, 'F');
                        $docIntern = (int) $nControlP[3];
                        $emiDate = date_format(date_create($identificacion['fecEmi']),"d/m/Y");

                        if(isset($receptor['nombre'])) $nameCliente = mb_strtoupper($receptor['nombre'], 'UTF-8');
                        if(isset($sujetoExcluido['nombre'])) $nameCliente = mb_strtoupper($sujetoExcluido['nombre'], 'UTF-8');

                        $jsonFile = $this->createJsonFile($jsonInfo, $identificacion['codigoGeneracion'], $respHacienda, $firmaJson);

                        switch($this->session->userdata('idaccount')) {
                            case '1490796':
                            case '4618':
                            case '2585TIENDAS':
                            //case '2815622':
                            case '1708':
                            case '3406536':
                            case '2535420':
                            case '2154998':
                            case '776777':
                            case '3338933':
                            case '2539313':
                            case '3317013':
                            case '1492935':
                                $response = $this->sendEmailWithPdf($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear);
                            break;
                            default:
                                $response = $this->sendEmailWithPdfResend($nombre_archivo, $fullpath, $identificacion['numeroControl'], $docIntern, $emiDate, $tipoDoc['descrip'], $resumen['totalPagar'], $razonSocial, $jsonFile, $infoDoc->correo, $nameCliente, $trannum, $idYear, $idCliente, $tipoDocumento, $idCentro);
                        }

                        if($response == true){
                            $title = 'Correo Enviado';
                            $bodyMsg = 'DTE enviado exitosamente a la direccion de correo <b style=\'color: #79bd53;\'>' . $infoDoc->correo . '</b>';
                            $type = 'success';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }else{
                            $title = 'Error de Envio';
                            $bodyMsg = 'DTE no pudo ser enviado a la dirección de correo <b style=\'color: #f27474;\'>' . $infoDoc->correo . '</b>';
                            $type = 'error';
                            echo $this->closeTabFunction($title, $bodyMsg, $type);
                        }
                    }else{
                        $title = 'Error de Envio';
                        $bodyMsg = 'DTE no pudo ser enviado debido a que el cliente no tiene dirección de correo registrada en el sistema.';
                        $type = 'error';
                        echo $this->closeTabFunction($title, $bodyMsg, $type);
                    }
                }
            }
        }
        //--------------------------------------------------

        #Enviar Documento Tributario Electronico por Correo
        function sendEmailWithPdf($nombre_archivo, $fullpath, $numFact, $docIntern, $fecha, $tipoDoc, $monto, $razonSocial, $jsonFile, $recepCorreo, $nameCliente, $trannum, $idYear){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->model('global_model');
                $this->load->model('dev_model');
                $this->load->model('pedclientes_model');

                $empCorreo  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $empTelefono  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);

                $nameImagen = $this->pedclientes_model->getnameImg();
                $backColor = $this->session->userdata('hdBackground');
                $lettersColor = $this->session->userdata('hdFontcolor');

                if($nComercial == ''){
                    $nComercial = 'Cliente';
                }

                $bodyText = '<head>
                    <meta charset="UTF-8">
                    <meta content="width=device-width, initial-scale=1" name="viewport">
                    <meta name="x-apple-disable-message-reformatting">
                    <meta http-equiv="X-UA-Compatible" content="IE=edge">
                    <meta content="telephone=no" name="format-detection">
                    <title></title>
                    <style>
                        body {
                            margin: 0;
                            padding: 0;
                            width: 100%;
                            font-family: helvetica, "helvetica neue", arial, verdana, sans-serif;
                            -webkit-text-size-adjust: 100%;
                            -ms-text-size-adjust: 100%;
                        }
                    </style>
                </head>
            
                <body>
                    <div class="es-wrapper-color">
                        <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0">
                            <tbody>
                                <tr>
                                    <td class="esd-email-paddings" valign="top">
                                        <table cellpadding="0" cellspacing="0" class="es-header" align="center" style="margin-bottom: 2%;">
                                            <tbody>
                                                <tr>
                                                    <td class="es-adaptive esd-stripe" align="center" esd-custom-block-id="88593">
                                                        <table class="es-header-body" style="background-color: '.$backColor.'; padding: 2%;" width="600" cellspacing="0" cellpadding="0" bgcolor="'.$backColor.'" align="center">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" style="background-color: '.$backColor.'; color: '.$lettersColor.'; font-weight: bold; font-size: 40px; height: 45px;" bgcolor="'.$backColor.'" align="center">
                                                                    '.strtoupper($nComercial).'
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table class="es-content" cellspacing="0" cellpadding="0" align="center">
                                            <tbody>
                                                <tr>
                                                    <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                        <table class="es-content-body" style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="esd-structure es-p40t es-p20r es-p20l" style="background-color: transparent; background-position: left top;" bgcolor="transparent" align="left">
                                                                        <table width="100%" cellspacing="0" cellpadding="0">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td class="esd-container-frame" width="360" valign="top" align="center">
                                                                                        <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td class="esd-block-image es-p5t es-p5b" align="center" style="font-size:0"><a target="_blank"><img src="'.base_url().'assets/img/correoIcon.png" alt style="display: block;" width="125"></a></td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p15t es-p15b" align="center">
                                                                                                        <h1 style="color: #333333; font-size: 20px;"><strong>Estimado Cliente: </strong>'.$nameCliente.'</h1>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p35r es-p40l" align="left">
                                                                                                        <p style="text-align: center;">Le saludamos de '.mb_strtoupper($razonSocial, 'UTF-8').', adjunto enviamos Documento Tributario Electrónico, el cual fue generado por su compra.</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                        <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td colspan="2" class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#D4D4D4; border: 1px solid #000;" align="center">
                                                                                                        <p><b>Detalle del Documento:</b></p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                        <p><b>Número de Documento Tributario Electrónico:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                    </td>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                        <p>'.$numFact.'</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                        <p><b>Documento Interno No:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                    </td>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                        <p>'.$docIntern.'</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                        <p><b>Fecha:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                    </td>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                        <p>'.$fecha.'</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                        <p><b>Tipo de Documento Tributario:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                    </td>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                        <p>'.ucwords(strtolower($tipoDoc)).'</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                        <p><b>Monto:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                    </td>
                                                                                                    <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                        <p>$'.number_format($monto, 2, '.', ',').'</p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table class="es-footer" cellspacing="0" cellpadding="0" align="center">
                                            <tbody>
                                                <tr>
                                                    <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                        <table class="es-footer-body" width="600" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="margin-top: 2%;">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="esd-structure es-p10t es-p30b es-p20r es-p20l" style=" background-color: '.$backColor.'; background-position: left top; padding: 3%;" bgcolor="'.$backColor.'" align="left">
                                                                        <table width="100%" cellspacing="0" cellpadding="0">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td class="esd-container-frame" width="560" valign="top" align="center">
                                                                                        <table width="100%" cellspacing="0" cellpadding="0">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td class="esd-block-text es-p5t es-p5b" align="center">
                                                                                                        <h2 style="font-size: 12px; color: '.$lettersColor.';"><strong>Para cualquier consulta, escribanos a <a style="text-decoration: none; color: '.$lettersColor.';">'.$empCorreo.'</a> o llamenos al <a style="text-decoration: none; color: '.$lettersColor.';">'.$empTelefono.'</a></strong></h2>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td esd-links-underline="none" esd-links-color="'.$lettersColor.'" class="esd-block-text es-p5b" align="center">
                                                                                                        <p style="font-size: 12px; color: '.$lettersColor.';">Para poder visualizar el documento tributario electrónico debe tener instalado en su equipo la aplicación <b>Adobe Acrobat Reader</b></p>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td esd-links-underline="none" esd-links-color="#000" class="esd-block-text es-p5b" align="center">
                                                                        <p style="font-size: 10px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </body>';

                /*$bodyText = '<meta charset="UTF-8">';
                $bodyText .= '<b>Estimado Cliente:</b><br><br>';
                $bodyText .= '<p>Le saludamos de '.mb_strtoupper($razonSocial, 'UTF-8').', adjunto enviamos Documento Tributario Electrónico, el cual fue generado por su compra.</p><br>';
                $bodyText .= '<p>Detalle del documento:</p>';
                $bodyText .= '<p><b>Número de Factura Electrónica: </b>'.$numFact.'<br>';
                $bodyText .= '<b>Documento interno No: </b>'.$docIntern.'<br>';
                $bodyText .= '<b>Fecha: </b>'.$fecha.'<br>';
                $bodyText .= '<b>Tipo de documento tributario: </b>'.ucfirst(strtolower($tipoDoc)).'<br>';
                $bodyText .= '<b>Monto: $</b>'.number_format($monto, 2, '.', ',').'</p><br>';
                $bodyText .= '<p>Para cualquier consulta, escribanos a '.$empCorreo.' o llamenos al '.$empTelefono.'</p>';
                $bodyText .= '<br>';
                $bodyText .= '<p style="font-size: 9px;">Para poder visualizar el documento tributario electrónico debe tener instalado en su equipo la aplicación <b>Adobe Acrobat Reader</b></p><br>';*/
                
                $email = new PHPMailer();
                $email->SMTPAuth   = false; // Enable SMTP authentication
                $email->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
                $email->Port       = 587;                  // TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above
                $email->CharSet = "UTF-8";
                $email->setFrom($empCorreo, $nComercial); //Name is optional
                $email->isHTML(true);
                $email->Subject  = 'Documento Tributario Electrónico';
                $email->Body     = $bodyText;
                $email->Encoding = 'base64';
                //$email->AddAddress('eduardogomez@versanetsa.com');
                //$email->AddAddress('soporte@versanetsa.com');
                //$email->AddAddress('kevin100@versanetsa.com');
                $email->AddAddress($recepCorreo);
                //$email->AddAddress('cristian.bernabel10@gmail.com');

                $file_to_attach = $fullpath;

                $email->AddAttachment($file_to_attach, $nombre_archivo);

                $codGeneracion = explode('.' ,$nombre_archivo);
                $email->AddAttachment($jsonFile, $codGeneracion[0].'.json');

                $mailStatus = $email->Send();
                
                if(file_exists($fullpath)){
                    unlink($fullpath);
                }

                if(file_exists($jsonFile)) unlink($jsonFile);

                if($mailStatus) $this->dev_model->confirmMailIsSent($trannum, $idYear);

                return $mailStatus;
            }
        }

        function sendEmailWithPdfResend($nombre_archivo, $fullpath, $numFact, $docIntern, $fecha, $tipoDoc, $monto, $razonSocial, $jsonFile, $recepCorreo, $nameCliente, $trannum, $idYear, $idClienteFact = '', $tipoDocumento = '', $idCentro = '') {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
        
                $this->load->model('global_model');
                $this->load->model('dev_model');
                $this->load->model('pedclientes_model');
				
				$nombrevar = 'pos_cliente0'.$idCentro;
                if ($idCentro != '') {
                    $idclientePred = (int) $this->global_model->getValorNumVariable($nombrevar);
                } else {
                    $idclientePred = 1;
                }
                $empCorreo  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);
                $empTelefono  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
        
                $nameImagen = $this->pedclientes_model->getnameImg();
                $backColor = $this->session->userdata('hdBackground');
                $lettersColor = $this->session->userdata('hdFontcolor');

                if ($tipoDocumento == '14' || $tipoDocumento == '07') {
                    //$idClienteFact = 0;
                    if ($nComercial == '') {
                        $nComercial = 'Cliente';
                    }
            
                    // Cuerpo del correo 
                    $bodyText = '<head>
                        <meta charset="UTF-8">
                        <meta content="width=device-width, initial-scale=1" name="viewport">
                        <meta name="x-apple-disable-message-reformatting">
                        <meta http-equiv="X-UA-Compatible" content="IE=edge">
                        <meta content="telephone=no" name="format-detection">
                        <title></title>
                        <style>
                            body {
                                margin: 0;
                                padding: 0;
                                width: 100%;
                                font-family: helvetica, "helvetica neue", arial, verdana, sans-serif;
                                -webkit-text-size-adjust: 100%;
                                -ms-text-size-adjust: 100%;
                            }
                        </style>
                    </head>
                
                    <body>
                        <div class="es-wrapper-color">
                            <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0">
                                <tbody>
                                    <tr>
                                        <td class="esd-email-paddings" valign="top">
                                            <table cellpadding="0" cellspacing="0" class="es-header" align="center" style="margin-bottom: 2%;">
                                                <tbody>
                                                    <tr>
                                                        <td class="es-adaptive esd-stripe" align="center" esd-custom-block-id="88593">
                                                            <table class="es-header-body" style="background-color: '.$backColor.'; padding: 2%;" width="600" cellspacing="0" cellpadding="0" bgcolor="'.$backColor.'" align="center">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" style="background-color: '.$backColor.'; color: '.$lettersColor.'; font-weight: bold; font-size: 40px; height: 45px;" bgcolor="'.$backColor.'" align="center">
                                                                        '.strtoupper($nComercial).'
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="es-content" cellspacing="0" cellpadding="0" align="center">
                                                <tbody>
                                                    <tr>
                                                        <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                            <table class="es-content-body" style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="esd-structure es-p40t es-p20r es-p20l" style="background-color: transparent; background-position: left top;" bgcolor="transparent" align="left">
                                                                            <table width="100%" cellspacing="0" cellpadding="0">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td class="esd-container-frame" width="360" valign="top" align="center">
                                                                                            <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-image es-p5t es-p5b" align="center" style="font-size:0"><a target="_blank"><img src="'.base_url().'assets/img/correoIcon.png" alt style="display: block;" width="125"></a></td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p15t es-p15b" align="center">
                                                                                                            <h1 style="color: #333333; font-size: 20px;"><strong>Estimado Cliente: </strong>'.$nameCliente.'</h1>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p35r es-p40l" align="left">
                                                                                                            <p style="text-align: center;">Le saludamos de '.mb_strtoupper($razonSocial, 'UTF-8').', adjunto enviamos Documento Tributario Electrónico, el cual fue generado por su compra.</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                            <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                    <tr>
                                                                                                        <td colspan="2" class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#D4D4D4; border: 1px solid #000;" align="center">
                                                                                                            <p><b>Detalle del Documento:</b></p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                            <p><b>Número de Documento Tributario Electrónico:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                        </td>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                            <p>'.$numFact.'</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                            <p><b>Documento Interno No:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                        </td>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                            <p>'.$docIntern.'</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                            <p><b>Fecha:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                        </td>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                            <p>'.$fecha.'</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                            <p><b>Tipo de Documento Tributario:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                        </td>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                            <p>'.ucwords(strtolower($tipoDoc)).'</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                            <p><b>Monto:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                        </td>
                                                                                                        <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                            <p>$'.number_format($monto, 2, '.', ',').'</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="es-footer" cellspacing="0" cellpadding="0" align="center">
                                                <tbody>
                                                    <tr>
                                                        <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                            <table class="es-footer-body" width="600" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="margin-top: 2%;">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="esd-structure es-p10t es-p30b es-p20r es-p20l" style=" background-color: '.$backColor.'; background-position: left top; padding: 3%;" bgcolor="'.$backColor.'" align="left">
                                                                            <table width="100%" cellspacing="0" cellpadding="0">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td class="esd-container-frame" width="560" valign="top" align="center">
                                                                                            <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                <tbody>
                                                                                                    <tr>
                                                                                                        <td class="esd-block-text es-p5t es-p5b" align="center">
                                                                                                            <h2 style="font-size: 12px; color: '.$lettersColor.';"><strong>Para cualquier consulta, escribanos a <a style="text-decoration: none; color: '.$lettersColor.';">'.$empCorreo.'</a> o llamenos al <a style="text-decoration: none; color: '.$lettersColor.';">'.$empTelefono.'</a></strong></h2>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td esd-links-underline="none" esd-links-color="'.$lettersColor.'" class="esd-block-text es-p5b" align="center">
                                                                                                            <p style="font-size: 12px; color: '.$lettersColor.';">Para poder visualizar el documento tributario electrónico debe tener instalado en su equipo la aplicación <b>Adobe Acrobat Reader</b></p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td esd-links-underline="none" esd-links-color="#000" class="esd-block-text es-p5b" align="center">
                                                                            <p style="font-size: 10px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525</a></p>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </body>';
                    
                    // Validar el dominio del correo
                    $mailValidation = $this->validarDominioCorreo($recepCorreo);
                    $empCorreo = 'dte@goxpos3.com';
            
                    if ($mailValidation) {
                        // Configurar los datos para Resend
                        $data = [
                            'from' => $nComercial . ' <' . $empCorreo . '>', // Remitente
                            'to' => [$recepCorreo], // Destinatario
                            'subject' => 'Documento Tributario Electrónico', // Asunto
                            'html' => $bodyText, // Cuerpo del correo en HTML
                            'attachments' => [
                                [
                                    'filename' => $nombre_archivo,
                                    'content' => base64_encode(file_get_contents($fullpath)) // Adjuntar el PDF
                                ],
                                [
                                    'filename' => explode('.', $nombre_archivo)[0] . '.json',
                                    'content' => base64_encode(file_get_contents($jsonFile)) // Adjuntar el JSON
                                ]
                            ]
                        ];
            
                        // Convertir datos a JSON
                        $payload = json_encode($data);
            
                        // Configurar cURL para enviar la solicitud a Resend
                        $ch = curl_init('https://api.resend.com/emails');
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Content-Type: application/json',
                            'Authorization: Bearer re_DQtBqD7F_JheoTP4Wmxn34HtcbTAw5rKT' // Reemplaza con tu API Key de Resend
                        ]);
            
                        // Ejecutar la solicitud
                        $response = curl_exec($ch);
                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                        curl_close($ch);
            
                        // Verificar la respuesta
                        if ($httpCode == 200) {
                            $mailStatus = true; // Correo enviado correctamente
                        } else {
                            $mailStatus = false; // Error al enviar el correo
                            log_message('error', 'Error al enviar correo con Resend: ' . $response);
                        }
        
                    } else {
                        $mailStatus = true; // Si la validación del correo falla, asumimos que el correo se envió correctamente
                    }
            
                    // Eliminar archivos temporales
                    if (file_exists($fullpath)) {
                        unlink($fullpath);
                    }
                    if (file_exists($jsonFile)) {
                        unlink($jsonFile);
                    }
                } else {
                    $mailStatus = true;

                    if($this->session->userdata('idaccount') == '3292889'){
                        $idclientePred = 0;
                        $idClienteFact = 1;
                    }

                    if($this->session->userdata('idaccount') == '1905952'){
                        $idclientePred = 0;
                        $idClienteFact = 1;
                    }

                    if ($idClienteFact != '' && $idClienteFact != $idclientePred) {
        
                        if ($nComercial == '') {
                            $nComercial = 'Cliente';
                        }
                
                        // Cuerpo del correo 
                        $bodyText = '<head>
                            <meta charset="UTF-8">
                            <meta content="width=device-width, initial-scale=1" name="viewport">
                            <meta name="x-apple-disable-message-reformatting">
                            <meta http-equiv="X-UA-Compatible" content="IE=edge">
                            <meta content="telephone=no" name="format-detection">
                            <title></title>
                            <style>
                                body {
                                    margin: 0;
                                    padding: 0;
                                    width: 100%;
                                    font-family: helvetica, "helvetica neue", arial, verdana, sans-serif;
                                    -webkit-text-size-adjust: 100%;
                                    -ms-text-size-adjust: 100%;
                                }
                            </style>
                        </head>
                    
                        <body>
                            <div class="es-wrapper-color">
                                <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td class="esd-email-paddings" valign="top">
                                                <table cellpadding="0" cellspacing="0" class="es-header" align="center" style="margin-bottom: 2%;">
                                                    <tbody>
                                                        <tr>
                                                            <td class="es-adaptive esd-stripe" align="center" esd-custom-block-id="88593">
                                                                <table class="es-header-body" style="background-color: '.$backColor.'; padding: 2%;" width="600" cellspacing="0" cellpadding="0" bgcolor="'.$backColor.'" align="center">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" style="background-color: '.$backColor.'; color: '.$lettersColor.'; font-weight: bold; font-size: 40px; height: 45px;" bgcolor="'.$backColor.'" align="center">
                                                                            '.strtoupper($nComercial).'
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="es-content" cellspacing="0" cellpadding="0" align="center">
                                                    <tbody>
                                                        <tr>
                                                            <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                                <table class="es-content-body" style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td class="esd-structure es-p40t es-p20r es-p20l" style="background-color: transparent; background-position: left top;" bgcolor="transparent" align="left">
                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                        <tr>
                                                                                            <td class="esd-container-frame" width="360" valign="top" align="center">
                                                                                                <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                                    <tbody>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-image es-p5t es-p5b" align="center" style="font-size:0"><a target="_blank"><img src="'.base_url().'assets/img/correoIcon.png" alt style="display: block;" width="125"></a></td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p15t es-p15b" align="center">
                                                                                                                <h1 style="color: #333333; font-size: 20px;"><strong>Estimado Cliente: </strong>'.$nameCliente.'</h1>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p35r es-p40l" align="left">
                                                                                                                <p style="text-align: center;">Le saludamos de '.mb_strtoupper($razonSocial, 'UTF-8').', adjunto enviamos Documento Tributario Electrónico, el cual fue generado por su compra.</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </tbody>
                                                                                                </table>
                                                                                                <table style="background-position: left top;" width="100%" cellspacing="0" cellpadding="0">
                                                                                                    <tbody>
                                                                                                        <tr>
                                                                                                            <td colspan="2" class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#D4D4D4; border: 1px solid #000;" align="center">
                                                                                                                <p><b>Detalle del Documento:</b></p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                                <p><b>Número de Documento Tributario Electrónico:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                            </td>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                                <p>'.$numFact.'</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                                <p><b>Documento Interno No:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                            </td>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                                <p>'.$docIntern.'</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                                <p><b>Fecha:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                            </td>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                                <p>'.$fecha.'</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                                <p><b>Tipo de Documento Tributario:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                            </td>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                                <p>'.ucwords(strtolower($tipoDoc)).'</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="background-color:#E7E7E7; border: 1px solid #000;" align="right">
                                                                                                                <p><b>Monto:&nbsp;&nbsp;&nbsp;</b></p>
                                                                                                            </td>
                                                                                                            <td class="esd-block-text es-p25t es-p40r es-p40l" style="border: 1px solid #000;" align="center">
                                                                                                                <p>$'.number_format($monto, 2, '.', ',').'</p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </tbody>
                                                                                                </table>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="es-footer" cellspacing="0" cellpadding="0" align="center">
                                                    <tbody>
                                                        <tr>
                                                            <td class="esd-stripe" style="background-color: #fafafa;" bgcolor="#fafafa" align="center">
                                                                <table class="es-footer-body" width="600" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="margin-top: 2%;">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td class="esd-structure es-p10t es-p30b es-p20r es-p20l" style=" background-color: '.$backColor.'; background-position: left top; padding: 3%;" bgcolor="'.$backColor.'" align="left">
                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                    <tbody>
                                                                                        <tr>
                                                                                            <td class="esd-container-frame" width="560" valign="top" align="center">
                                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                    <tbody>
                                                                                                        <tr>
                                                                                                            <td class="esd-block-text es-p5t es-p5b" align="center">
                                                                                                                <h2 style="font-size: 12px; color: '.$lettersColor.';"><strong>Para cualquier consulta, escribanos a <a style="text-decoration: none; color: '.$lettersColor.';">'.$empCorreo.'</a> o llamenos al <a style="text-decoration: none; color: '.$lettersColor.';">'.$empTelefono.'</a></strong></h2>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td esd-links-underline="none" esd-links-color="'.$lettersColor.'" class="esd-block-text es-p5b" align="center">
                                                                                                                <p style="font-size: 12px; color: '.$lettersColor.';">Para poder visualizar el documento tributario electrónico debe tener instalado en su equipo la aplicación <b>Adobe Acrobat Reader</b></p>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </tbody>
                                                                                                </table>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td esd-links-underline="none" esd-links-color="#000" class="esd-block-text es-p5b" align="center">
                                                                                <p style="font-size: 10px; color: #000;">DOCUMENTO TRIBUTARIO ELECTRONICO GENERADO POR LA PLATAFORMA <b>GOXPOS</b> DE <b>VERSANET DIVISION DE EGGA S.A. de C.V.</b> - <a style="text-decoration: none; color: #000;">TEL: +503 2559 2525 WhatsApp: +503 7190 6538</a></p>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </body>';
                        
                        // Validar el dominio del correo
                        $mailValidation = $this->validarDominioCorreo($recepCorreo);
                        $empCorreo = 'dte@goxpos3.com';
                
                        if ($mailValidation) {
                            // Configurar los datos para Resend
                            $data = [
                                'from' => $nComercial . ' <' . $empCorreo . '>', // Remitente
                                'to' => [$recepCorreo], // Destinatario
                                'subject' => 'Documento Tributario Electrónico', // Asunto
                                'html' => $bodyText, // Cuerpo del correo en HTML
                                'attachments' => [
                                    [
                                        'filename' => $nombre_archivo,
                                        'content' => base64_encode(file_get_contents($fullpath)) // Adjuntar el PDF
                                    ],
                                    [
                                        'filename' => explode('.', $nombre_archivo)[0] . '.json',
                                        'content' => base64_encode(file_get_contents($jsonFile)) // Adjuntar el JSON
                                    ]
                                ]
                            ];
                
                            // Convertir datos a JSON
                            $payload = json_encode($data);
                
                            // Configurar cURL para enviar la solicitud a Resend
                            $ch = curl_init('https://api.resend.com/emails');
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                'Content-Type: application/json',
                                'Authorization: Bearer re_DQtBqD7F_JheoTP4Wmxn34HtcbTAw5rKT' // Reemplaza con tu API Key de Resend
                            ]);
                
                            // Ejecutar la solicitud
                            $response = curl_exec($ch);
                            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                            curl_close($ch);
                
                            // Verificar la respuesta
                            if ($httpCode == 200) {
                                $mailStatus = true; // Correo enviado correctamente
                            } else {
                                $mailStatus = false; // Error al enviar el correo
                                log_message('error', 'Error al enviar correo con Resend: ' . $response);
                            }
            
                        } else {
                            $mailStatus = true; // Si la validación del correo falla, asumimos que el correo se envió correctamente
                        }
                
                        // Eliminar archivos temporales
                        if (file_exists($fullpath)) {
                            unlink($fullpath);
                        }
                        if (file_exists($jsonFile)) {
                            unlink($jsonFile);
                        }
                    } else {
                        $mailStatus = true;
                    }
                }
        
                // Confirmar que el correo fue enviado
                if ($mailStatus) {
                    $this->dev_model->confirmMailIsSent($trannum, $idYear);
                }
        
                return $mailStatus;
            }
        }

        function validarDominioCorreo($email){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                // Valida el formato de correo
                if (filter_var($email, FILTER_VALIDATE_EMAIL)) {

                    //Extrae el dominio
                    $domain = substr(strrchr($email, '@'), 1);

                    // Verifica si el dominio tiene un registro MX
                    if (checkdnsrr($domain, 'MX')) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }

        #Crear JSON FILE para enviar
        function createJsonFile($information, $codGeneracion, $respHacienda, $firmaJson){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $file = $_SERVER['DOCUMENT_ROOT']."/".$codGeneracion.'.json';

                $information['respuestaHacienda'] = $respHacienda;
                $information['firma'] = $firmaJson;

                $json = json_encode($information, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
                
                file_put_contents($file, $json);

                //if(file_exists($file)) unlink($file);

                return $file;
            }
        }

        #Funcion para cerrar la ventana del navegador
        function closeTabFunction($title, $bodyMsg, $type){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $contentJS = '';
                //$contentJS .= '<script src="'.base_url().'node_modules/sweetalert2/dist/sweetalert2.all.min.js"></script>';
                $contentJS .= '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                $contentJS .= '<body></body>';

                $contentJS .= '<script type="text/JavaScript">';
                    $contentJS .= 'Swal.fire({';
                        $contentJS .= 'icon:  "'.$type.'",';
                        $contentJS .= 'title: "<h4 style=\'font-family: sans-serif !important; margin:0px;\'>'.$title.'</h4>",';
                        $contentJS .= 'html:  "<h5 style=\'font-family: sans-serif !important; margin:0px;\'>'.$bodyMsg.'</h5>",';
                        $contentJS .= 'allowOutsideClick: false,';
                        $contentJS .= 'allowEscapeKey: false,';
                        $contentJS .= 'denyButtonText: \'Cerrar\',';
                        $contentJS .= 'showDenyButton: false,';
                        
                        //$contentJS .= 'preDeny: function(e){ window.close(); }';
                        $contentJS .= 'preConfirm: function(e){ window.close(); }';
                    $contentJS .= '})';
                $contentJS .= '</script>';

                return $contentJS;
            }
        }

        function ticketDTEnoFiscal($trannum, $idYear = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $this->load->model('dev_model');
                $this->load->model('dte_model');
                $comandosTM = new comandosTM();

                $informacion = $this->dev_model->electronicBills($trannum, $idYear);

                foreach($informacion as $info){
                    $jsonInfo = $info['jsonDoc'];
                    $sRecepcion = $info['sRecepcion'];
                    $respHacienda = $info['respHacienda'];
                    $firmaJson = $info['firmaJson'];
                }

                if(isset($jsonInfo['identificacion'])) $identificacion = $jsonInfo['identificacion'];
                if(isset($jsonInfo['documentoRelacionado'])) $documentoRelacionado = $jsonInfo['documentoRelacionado'];
                if(isset($jsonInfo['emisor'])) $emisor = $jsonInfo['emisor'];
                if(isset($emisor['direccion'])) $direcEmisor = $emisor['direccion'];
                if(isset($jsonInfo['receptor'])) $receptor = $jsonInfo['receptor'];
                if(isset($jsonInfo['sujetoExcluido'])) $sujetoExcluido = $jsonInfo['sujetoExcluido'];
                if(isset($receptor['direccion'])) $direcReceptor = $receptor['direccion'];
                if(isset($sujetoExcluido['direccion'])) $direcRsujetoExcluido = $sujetoExcluido['direccion'];
                if(isset($jsonInfo['ventaTercero'])) $ventaTercero = $jsonInfo['ventaTercero'];
                if(isset($jsonInfo['cuerpoDocumento'])) $cuerpoDocumento = $jsonInfo['cuerpoDocumento'];
                if(isset($jsonInfo['resumen'])) $resumen = $jsonInfo['resumen'];
                if(isset($resumen['tributos'])) $tributos  = $resumen['tributos'];
                if(isset($jsonInfo['extension'])) $extension = $jsonInfo['extension'];
                if(isset($jsonInfo['apendice'])) $apendice = $jsonInfo['apendice'];
                $tipoDocumento = '';

                $dteSucursal = $this->global_model->getValorNumVariable('dte_sucursal');

                if ( $dteSucursal == 0 ) {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 10);
                    $nameImagen = $this->pedclientes_model->getnameImg();
                } else {
                    $razonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$this->session->userdata('idcentrouser'), 1);
                    $nComercial  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$this->session->userdata('idcentrouser'), 2);
                    $categoria  = $this->global_model->getDatosGeneralesEmp('g_empdatos_0'.$this->session->userdata('idcentrouser'), 10);
                    $nameImagen = $this->global_model->getValorTextoVariable('dte_logo_0'.$this->session->userdata('idcentrouser'));
                }

                $modFac = $this->dte_model->getDescripCodigoDTE($identificacion['tipoModelo'],'CAT-003');
                $modeloFacturacion = explode(" ", $modFac['descrip']);
                $tipoTrans = $this->dte_model->getDescripCodigoDTE($identificacion['tipoOperacion'],'CAT-004');
                $tipoTransmision = explode(" ", $tipoTrans['descrip']);
                $tipoDoc = $this->dte_model->getDescripCodigoDTE($identificacion['tipoDte'],'CAT-002');
                $tipoDocumento = $identificacion['tipoDte'];
                $formaPagoDescrip = $this->dte_model->getDescripFormaDePagoDocumento($trannum, $idYear);
                if($idYear == 0) $efectivo = (int) $this->ventas_model->verificaPagoEfectivo($trannum);

                if(isset($direcReceptor)){
                    $receptorMun = $this->dev_model->getMunicipioDTE($direcReceptor['municipio'],$direcReceptor['departamento']);
                    $receptorDep = $this->dev_model->getDepartamentoDTE($direcReceptor['departamento']);
                }else{
                    $receptorMun = array();
                    $receptorDep = array();
                }

                if(isset($direcRsujetoExcluido)){
                    $sujetoExcluidoMun = $this->dev_model->getMunicipioDTE($direcRsujetoExcluido['municipio'],$direcRsujetoExcluido['departamento']);
                    $sujetoExcluidoDep = $this->dev_model->getDepartamentoDTE($direcRsujetoExcluido['departamento']);
                }else{
                    $sujetoExcluidoMun = array();
                    $sujetoExcluidoDep = array();
                }

                $receptorDoc = array();
                if(isset($receptor['tipoDocumento'])){
                    if($receptor['tipoDocumento'] != ''){
                        $receptorDoc = $this->dte_model->getDescripCodigoDTE($receptor['tipoDocumento'],'CAT-022');
                    }
                }

                $sujetoExcluidoDoc = array();
                if(isset($sujetoExcluido['tipoDocumento'])){
                    if($sujetoExcluido['tipoDocumento'] != ''){
                        $sujetoExcluidoDoc = $this->dte_model->getDescripCodigoDTE($sujetoExcluido['tipoDocumento'],'CAT-022');
                    }
                }

                if(!isset($receptorDoc['descrip'])){
                    $receptorDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($sujetoExcluidoDoc['descrip'])){
                    $sujetoExcluidoDoc['descrip'] = 'Doc. Identificación';
                }

                if(!isset($receptor['nombreComercial'])){
                    $receptor['nombreComercial'] = '';
                }

                if(!isset($direcReceptor['complemento'])){
                    $direcReceptor['complemento'] = '';
                }

                if(!isset($direcRsujetoExcluido['complemento'])){
                    $direcRsujetoExcluido['complemento'] = '';
                }

                if(!isset($receptor['correo'])){
                    $receptor['correo'] = '';
                }

                $recepDepartamento = '';
                $recepMunicipio = '';

                $condicionPago = array();
                if(isset($resumen['condicionOperacion'])){
                    if($resumen['condicionOperacion'] != ''){
                        $condicionPago = $this->dte_model->getDescripCodigoDTE($resumen['condicionOperacion'],'CAT-016');
                    }
                }else{
                    $condicionPago['descrip'] = '';
                }

                if($tipoDocumento == '03'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recpAct_economica = substr(strtoupper($this->eliminarTildes($receptor['descActividad'])), 0, 64);
                    $recepDocDescrip = 'NIT: ';
                    $recepDoc = substr($receptor['nit'], 0, 19);
                    $recepCorreo = substr($receptor['correo'], 0, 64);
                    $recepNRC = substr($receptor['nrc'], 0, 19);
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = substr($condicionPago['descrip'], 0, 19);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['totalPagar']), 2, '.', ',');
                }

                if($tipoDocumento == '01'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recepDocDescrip = strtoupper($this->eliminarTildes($receptorDoc['descrip']));
                    $recepDoc = substr($receptor['numDocumento'], 0, 19);
                    $recepCorreo = substr($receptor['correo'], 0, 64);
                    $recepNRC = substr($receptor['nrc'], 0, 19);
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = substr($condicionPago['descrip'], 0, 19);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['totalPagar']), 2, '.', ',');
                }
                
                if($tipoDocumento == '11'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recepDocDescrip = strtoupper($this->eliminarTildes($receptorDoc['descrip']));
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    $recepDoc = substr($receptor['numDocumento'], 0, 19);
                    $recepCorreo = '';
                    $recepNRC = '';
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepFormaPago = '';
                    //$recepDepartamento = substr(strtoupper($this->eliminarTildes($direcReceptor['nombrePais'])), 0, 64);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['totalPagar']), 2, '.', ',');
                }

                if($tipoDocumento == '05'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recpAct_economica = substr(strtoupper($this->eliminarTildes($receptor['descActividad'])), 0, 64);
                    $recepDocDescrip = 'NIT: ';
                    $recepDoc = substr($receptor['nit'], 0, 19);
                    $recepCorreo = substr($receptor['correo'], 0, 64);
                    $recepNRC = substr($receptor['nrc'], 0, 19);
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = substr($condicionPago['descrip'], 0, 19);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['montoTotalOperacion']), 2, '.', ',');
                }

                if($tipoDocumento == '14'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($sujetoExcluido['nombre'])), 0, 64);
                    $recepDocDescrip = strtoupper($this->eliminarTildes($sujetoExcluidoDoc['descrip']));
                    $recepDoc = substr($sujetoExcluido['numDocumento'], 0, 19);
                    $recepCorreo = substr($sujetoExcluido['correo'], 0, 64);
                    $recepNRC = '';
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcRsujetoExcluido['complemento'])), 0, 64);
                    $recepTelefono = substr($sujetoExcluido['telefono'], 0, 19);
                    foreach($sujetoExcluidoMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = '';
                    foreach($sujetoExcluidoDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['totalPagar']), 2, '.', ',');
                }

                if($tipoDocumento == '06'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recepDocDescrip = 'NIT: ';
                    $recepDoc = substr($receptor['nit'], 0, 19);
                    $recepCorreo = substr($receptor['correo'], 0, 64);
                    $recepNRC = substr($receptor['nrc'], 0, 19);
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = substr($condicionPago['descrip'], 0, 19);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalPagar = number_format(floatval($resumen['montoTotalOperacion']), 2, '.', ',');
                }

                if($tipoDocumento == '07'){
                    $recepRazonSocial = substr(strtoupper($this->eliminarTildes($receptor['nombre'])), 0, 64);
                    $recepDocDescrip = strtoupper($this->eliminarTildes($receptorDoc['descrip']));
                    $recepDoc = substr($receptor['numDocumento'], 0, 19);
                    $recepCorreo = substr($receptor['correo'], 0, 64);
                    $recepNRC = substr($receptor['nrc'], 0, 19);
                    $recepDireccion = substr(strtoupper($this->eliminarTildes($direcReceptor['complemento'])), 0, 64);
                    $recepTelefono = substr($receptor['telefono'], 0, 19);
                    foreach($receptorMun as $muni){
                        if(!isset($muni['municipio'])) $muni['municipio'] = '';
                        $recepMunicipio = substr(strtoupper($this->eliminarTildes($muni['municipio'])), 0, 64);
                        break;
                    }
                    $recepFormaPago = substr($condicionPago['descrip'], 0, 19);
                    foreach($receptorDep as $depto){
                        if(!isset($depto['depto'])) $depto['depto'] = '';
                        $recepDepartamento = substr(strtoupper($this->eliminarTildes($depto['depto'])), 0, 64);
                        break;
                    }
                    $totalSujetoRetencion = number_format($resumen['totalSujetoRetencion'], 2, '.', ',');
                    $totalIVAretenido = number_format($resumen['totalIVAretenido'], 2, '.', ',');
                }

                if($tipoDocumento == '14' || $tipoDocumento == '07'){
                    $infoFact = $this->dev_model->getTipoDocumentoTablaIVA($trannum, $idYear);
                    //$idClase = $infoFact->doc_tipo;
                    $idClase = $infoFact->invclase;
                    $idCentro = (int) $infoFact->idcentro;
                    $idCliente = (int) $infoFact->idcps;
                }else{
                    $infoFact = $this->ventas_model->getDatosFactura($trannum);
                    foreach($infoFact as $info){
                        $idClase = $info->idclase;
                        $nameSucursal = $info->nameSucursal;
                        $nameVendedor = $info->nameVendedor;
                        $idCentro = (int) $info->idcentro;
                        $idcaja = $info->idcaja;
                    }
                }

                $sucursalInfo = $this->sucursal_model->getSucursal($idCentro);

                if ($sucursalInfo != false || $sucursalInfo != null) {
                    if ($sucursalInfo->direccion != '') {
                        $direcEmisor['complemento'] = $sucursalInfo->direccion;
                    }

                    if ($sucursalInfo->telefono != '') {
                        $emisor['telefono'] = implode('', explode('-', $sucursalInfo->telefono));
                    }
                }

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;

                $cmds .= comandosTM::FontNormal;
                $cmds .= wordwrap('CODIGO GENERACION:', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim($identificacion['codigoGeneracion']), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap('NO CONTROL:', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim($identificacion['numeroControl']), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap('SELLO:', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim($sRecepcion), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($razonSocial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= wordwrap('DIR: '.strtoupper($this->eliminarTildes($direcEmisor['complemento'])), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(substr('NRC: '.$emisor['nrc'], 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(substr('NIT: '.$emisor['nit'], 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(substr('GIRO: '.strtoupper($this->eliminarTildes($emisor['descActividad'])), 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($emisor['descActividad']) > 48){
                    $cmds .= wordwrap(trim(substr(strtoupper($this->eliminarTildes($emisor['descActividad'])), 48, 48)), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= wordwrap('DATOS DEL CLIENTE', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;

                $cmds .= wordwrap(trim(substr('NRC: '.$recepNRC, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(substr($recepDocDescrip.$recepDoc, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(substr('NOMBRE: '.$recepRazonSocial, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($recepRazonSocial) > 48){
                    $cmds .= wordwrap(trim(substr($recepRazonSocial, 48, 48)), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= wordwrap(trim(substr('DIR: '.$recepDepartamento, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(substr('TEL: '.$recepTelefono, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(substr('CORREO: '.$recepCorreo, 0, 48)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= wordwrap('NO ES UN DOCUMENTO FISCAL', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap('PARA CONSULTAS ESCRIBA AL CORREO', 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap($emisor['correo'], 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(substr($emisor['telefono'], 0, 4).'-'.substr($emisor['telefono'], 4, 8), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                
                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= date_format(date_create($identificacion['fecEmi']),"d/m/Y").' '.date_format(date_create($identificacion['horEmi']),"h:i:s A");
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap('TIPO DOC: '.strtoupper($this->eliminarTildes($tipoDoc['descrip'])), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap('#NO_UNICO: '.$trannum, 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if ($idYear == 0) {
                    $cmds .= wordwrap('VENDEDOR: '.strtoupper($this->eliminarTildes($nameVendedor)), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                if ($idYear != 0) {
                    foreach($cuerpoDocumento as $body){
                        if($tipoDocumento == '03' || $tipoDocumento == '05'){
                            $precioUni = floatval($body['precioUni']) * 1.13;
                            $subTotalItems = $body['cantidad'] * $precioUni;
                        }else{
                            $precioUni = floatval($body['precioUni']);
                            $subTotalItems = $body['cantidad'] * floatval($body['precioUni']);
                        }
    
                        $infoExtraPro = $this->dte_model->getInfoExtraProducto($body['codigo']);
                        $infoExtraProTran100k = $this->dte_model->getInfoExtraProductoTran100k($trannum, $body['codigo']);
                        //$modelo = strtoupper($this->eliminarTildes($infoExtraPro->modelo));
                        $um = $infoExtraProTran100k->um;
    
                        $cmds .= $comandosTM->padText(substr($body['cantidad'], 0, 4)." @", 6, "BOTH");
                        $cmds .= ' ('.$body['codigo'].') '.strtoupper($this->eliminarTildes($body['descripcion']));
                        $cmds .= comandosTM::LineFeed;
                        if($this->session->userdata("idaccount")=="1657895") {
                            $cmds .= $comandosTM->padText(strtoupper($um), 11, "RIGHT");
                            $cmds .= $comandosTM->pad(15);
                            $cmds .= $comandosTM->padText('$'.number_format($precioUni, 2, '.', ',')." =", 11, "LEFT");
                            $cmds .= $comandosTM->padText('$'.number_format($subTotalItems, 2, '.', ','), 11, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        } else {
                            $cmds .= $comandosTM->pad(26);
                            $cmds .= $comandosTM->padText('$'.number_format($precioUni, 2, '.', ',')." =", 11, "LEFT");
                            $cmds .= $comandosTM->padText('$'.number_format($subTotalItems, 2, '.', ','), 11, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
                    }
                } else {
                    $productos = $this->dte_model->getDetalleProductosJSON($trannum);
                    foreach($productos as $pro) {
                        $precioUni = ($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100)));
                        $precioUni = number_format(abs($precioUni), 6 ,'.','');
                        $subTotalItems = abs($pro->cantidad) * floatval($precioUni);
    
                        if($pro->tipo == "4"){
                            $idpro = "";
                            $nombrepro = strtoupper(trim($pro->vnNotas));
    
                            if ( $nombrepro == '' ) {
                                $nombrepro = strtoupper(trim($pro->descrip));
                            }
                        }else{
                            $idpro = $pro->idproducto;
                            $nombrepro = strtoupper(trim($pro->descrip)).' '.$pro->vnNotas;
                        }

                        if (intval(abs($pro->cantidad)) == floatval(abs($pro->cantidad))) {
                            $pro->cantidad = number_format(abs($pro->cantidad), 0, '', '');
                        } else {
                            $pro->cantidad = number_format(abs($pro->cantidad), 2, '.', '');
                        }
    
                        $cmds .= $comandosTM->padText(substr($pro->cantidad, 0, 4)." @", 6, "BOTH");
                        $cmds .= ' ('.$pro->idproducto.') '.strtoupper($this->eliminarTildes($nombrepro));
                        $cmds .= comandosTM::LineFeed;
                        if($this->session->userdata("idaccount")=="1657895") {
                            $cmds .= $comandosTM->padText(strtoupper($pro->umVenta), 11, "RIGHT");
                            $cmds .= $comandosTM->pad(15);
                            $cmds .= $comandosTM->padText('$'.number_format($precioUni, 2, '.', ',')." =", 11, "LEFT");
                            $cmds .= $comandosTM->padText('$'.number_format($subTotalItems, 2, '.', ','), 11, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        } else {
                            $cmds .= $comandosTM->pad(26);
                            $cmds .= $comandosTM->padText('$'.number_format($precioUni, 2, '.', ',')." =", 11, "LEFT");
                            $cmds .= $comandosTM->padText('$'.number_format($subTotalItems, 2, '.', ','), 11, "LEFT");
                            $cmds .= comandosTM::LineFeed;
                        }
                    }
                }


                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
                
                if($this->session->userdata("idaccount")!="1708"){
                    $cmds .= str_repeat("-", 48);
                    $cmds .= comandosTM::LineFeed;

                    $arrayFormasDePago = [];
                    foreach($detailPagos as $key => $dtpagos){
                        $arrayFormasDePago[$key] = trim($dtpagos->namePago);
                    }

                    $formasDePagoString = implode(", ", $arrayFormasDePago);
                    //$cmds .= wordwrap('FORMA DE PAGO: '.strtoupper($this->eliminarTildes($recepFormaPago)), 48, comandosTM::LineFeed);
                    //$cmds .= wordwrap('FORMA DE PAGO: '.strtoupper($this->eliminarTildes($formaPagoDescrip)), 48, comandosTM::LineFeed);
                    $cmds .= wordwrap('FORMA DE PAGO: '.strtoupper($this->eliminarTildes($formasDePagoString)), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= str_repeat("-", 48);
                    $cmds .= comandosTM::LineFeed;
                }else{
                    $cmds .= str_repeat("-", 48);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= wordwrap('FORMA DE PAGO:', 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;

                    foreach($detailPagos as $dtpagos){
                        // $notasPago = $dtpagos->notas;
                        $cmds .= wordwrap(strtoupper($dtpagos->namePago).":  $".number_format(abs($dtpagos->valor)-abs($dtpagos->vuelto), 2 ,'.',''), 48, comandosTM::LineFeed);
                        $cmds .= comandosTM::LineFeed;
                        // $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                    }

                    // $cmds .= str_repeat("-", 48);
                    // $cmds .= comandosTM::LineFeed;
                }

                

                $totalPagado = 0;
                // $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    //$notasPago = $dtpagos->notas;
                    //$nameForma = substr($dtpagos->namePago, 0, 13);
                    //$totalString = strlen($nameForma);
                    //$tipoPago = $dtpagos->cajclase;

                    //$cmds .= $comandosTM->pad(10);
                    //$cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    //$cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");     
                    //$cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = floatval(str_replace(',', '', $totalPagar)) - floatval(str_replace(',', '', $totalPagado));

                if($tipoDocumento != '07'){
                    $cmds .= wordwrap('TOTAL: $'.number_format(floatval(str_replace(',', '', $totalPagar)), 2, '.', ','), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                }else{
                    $cmds .= wordwrap('TOTAL RETENCION: $'.number_format(floatval(str_replace(',', '', $totalPagar)), 2, '.', ','), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= wordwrap('TOTAL IVA RETENIDO: $'.number_format(floatval(str_replace(',', '', $totalPagar)), 2, '.', ','), 48, comandosTM::LineFeed);
                    $cmds .= comandosTM::LineFeed;
                }

                if($idYear == 0){
                    if($efectivo == 1){
                        if($totalVuelto != 0){
                            $cmds .= wordwrap('RECIBIDO: $'.number_format(floatval(str_replace(',', '', $totalPagado)), 2, '.', ','), 48, comandosTM::LineFeed);
                            $cmds .= comandosTM::LineFeed;
                            $cmds .= wordwrap('CAMBIO: $'.number_format(floatval(str_replace(',', '', abs($totalVuelto))), 2, '.', ','), 48, comandosTM::LineFeed);
                            $cmds .= comandosTM::LineFeed;
                        }
                    }
                }

                $cmds .= str_repeat("=", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::LineFeed;

                // Generar el código QR utilizando el API de Google
                $urlQR = "https://admin.factura.gob.sv/consultaPublica?ambiente=".$identificacion['ambiente']."&codGen=".$identificacion['codigoGeneracion']."&fechaEmi=".$identificacion['fecEmi']."";

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= $comandosTM->generarQRCode($urlQR, 7);
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Escanea el codigo QR para consultar tu DTE";
                $cmds .= comandosTM::LineFeed;
                $cmds .= "o ingresa a:";
                $cmds .= comandosTM::LineFeed;
                $cmds .= "https://admin.factura.gob.sv/consultaPublica";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                if($idYear == 0){
                    if($efectivo == 1){
                        $cmds .= comandosTM::OpenDrawer;
                        $cmds .= comandosTM::LineFeed;
                    }
                }
                $cmds .= comandosTM::FullCut;

                if($this->session->userdata('idaccount') == '3504562'){
                    $cmds = $cmds . ' ' . $cmds;
                }

                $serverName = $this->session->userdata('server_name');
                if($serverName != 'www.goxpos.com'){
                    $serverName = substr($serverName, 0, -9);
                }

                $idcaja = $this->session->userdata('idcajauser');
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numZ = $caja->numz;
                }

                //$printerName = 'FACTURAS';
                if($printerName != ''){
                    $datosPrinter = explode('/', $printerName);
                }

                if(count($datosPrinter) > 1){
                    $printerIp = $datosPrinter[0];
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://'.$serverName.'/WebClientPrint/impresion.php?docType=1&tipoImpresion=3&printerIp='.$printerIp.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }else{
                    $this->ventas_model->setCommandsPrint($trannum, $cmds);
                    header('Location: webclientprintvi:http://'.$serverName.'/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                    exit;
                }
                
            }
        }

	}
?>