<?php
session_start();
include 'WebClientPrint.php';
use Neodynamic\SDK\Web\WebClientPrint;
use Neodynamic\SDK\Web\Utils;
use Neodynamic\SDK\Web\ClientPrintJob;
use Neodynamic\SDK\Web\DefaultPrinter;
use Neodynamic\SDK\Web\UserSelectedPrinter;
use Neodynamic\SDK\Web\InstalledPrinter;
use Neodynamic\SDK\Web\ParallelPortPrinter;
use Neodynamic\SDK\Web\SerialPortPrinter;
use Neodynamic\SDK\Web\NetworkPrinter;

$request = parse_url($_SERVER['REQUEST_URI']);
$query = $request['query'];
parse_str($query, $qs);

$trannum   = $qs['trannum'];
$idaccount = $qs['idaccount'];
$printerName = $qs['printerName'];
$tipoImpresion = $qs['tipoImpresion'];
$docType = $qs['docType'];

if($docType === ""){
    $docType = "1";
}

$data = file_get_contents('https://www.goxpos1.com/versanet/WebPrint/'.$trannum.'/'.$idaccount.'/'.$docType);

$comandosImpresion = $data;
$clienteImpresion = NULL;    

if ($tipoImpresion == '0') //impresion por defecto
{
    $clienteImpresion = new DefaultPrinter();

}
else if ($tipoImpresion == '1') //dialogo de seleccion de impresora
{
    $clienteImpresion = new UserSelectedPrinter();
}
else if ($tipoImpresion == '2') //impresion con nombre de impresora
{
    //$clienteImpresion = new InstalledPrinter("EPSON TM-U950");
    //$clienteImpresion->trayname = $qs['printerTray'];

    $clienteImpresion = new InstalledPrinter($qs['printerName']);
}
else if ($tipoImpresion == '3') //impresion con impresora en red
{
    //$clienteImpresion = new NetworkPrinter(192.168.1.xx,192.168.1.xx, 9100);
    $clienteImpresion = new NetworkPrinter($qs['printerIp'], $qs['printerIp'], 9100);
}
else if ($tipoImpresion == '4') //impresion con puerto paralelo
{
    //clienteImpresion = new ParallelPortPrinter('LPT1'); //use the printer available at LPT1 port on the client machine
    $clienteImpresion = new ParallelPortPrinter($qs['parallelPort']);
}

$cpj = new ClientPrintJob();
$cpj->clientPrinter = $clienteImpresion;
$cpj->printerCommands = $comandosImpresion;
$cpj->formatHexValues = true;

ob_start();
ob_clean();
header('Content-type: application/octet-stream');
echo $cpj->sendToClient();
ob_end_flush();

exit();

