<?php

require_once('WebClientPrint.php');
use Neodynamic\SDK\Web\WebClientPrint;
use Neodynamic\SDK\Web\Utils;
use Neodynamic\SDK\Web\ClientPrintJob;
use Neodynamic\SDK\Web\DefaultPrinter;
use Neodynamic\SDK\Web\UserSelectedPrinter;
use Neodynamic\SDK\Web\InstalledPrinter;
use Neodynamic\SDK\Web\ParallelPortPrinter;
use Neodynamic\SDK\Web\SerialPortPrinter;
use Neodynamic\SDK\Web\NetworkPrinter;

class ImpresionesController extends CI_Controller {
	

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html..
	 */

	
	function __construct(){
        parent::__construct();
    }
	
    public function imprimir()
	{
        $request = parse_url($_SERVER['REQUEST_URI']);
        $query = $request['query'];
        parse_str($query, $qs);
        $comandosImpresion = $qs['printerCommands'];
        $tipoImpresion = 1;

		$clienteImpresion = NULL;    

		if ($tipoImpresion == 0) //impresion por defecto
        {
            $clienteImpresion = new DefaultPrinter();

        }
        else if ($tipoImpresion == 1) //dialogo de seleccion de impresora
        {
            $clienteImpresion = new UserSelectedPrinter();
        }
        else if ($tipoImpresion == 2) //impresion con nombre de impresora
        {
            $nombreImpresora = $qs['printerName'];
            $clienteImpresion = new InstalledPrinter($nombreImpresora);
        }
        else if ($tipoImpresion == 3) //impresion con impresora en red
        {
			$ipImpresora = $this->input->post('printerIp');
			$puertoImpresora = $this->input->post('printerPort');
            $clienteImpresion = new NetworkPrinter($ipImpresora, $puertoImpresora);
        }

		$cpj = new ClientPrintJob();
        $cpj->clientPrinter = $clienteImpresion;
        $cpj->printerCommands = $comandosImpresion;
        $cpj->formatHexValues = true;
        
        ob_start();
        ob_clean();
        header('Content-type: application/octet-stream');
        echo $cpj->sendToClient();
        ob_end_flush();
        exit();
	}

	public function processRequest(){
        $request = parse_url($_SERVER['REQUEST_URI']);
        $query = $request['query'];
        parse_str($query, $qs);
        //IMPORTANT SETTINGS:
        //===================
        //Set wcpcache folder RELATIVE to WebClientPrint.php file
        //FILE WRITE permission on this folder is required!!!
        WebClientPrint::$wcpCacheFolder = APPPATH.'third_party/WebClientPrint/wcpcache/';
        //===================
 
        // Clean built-in Cache
        // NOTE: Remove it if you implement your own cache system
        //WebClientPrint::cacheClean(30); //in minutes

        //get session id from querystring if any
        $sid = NULL;
        if (isset($qs[WebClientPrint::SID])){
            $sid = $qs[WebClientPrint::SID];
        }
         
        try{
            //get request type
            $reqType = WebClientPrint::GetProcessRequestType($query);
             
            if($reqType == WebClientPrint::GenPrintScript ||
            $reqType == WebClientPrint::GenWcppDetectScript){
                //Let WebClientPrint to generate the requested script
                 
                //Get Absolute URL of this file
                $currentAbsoluteURL = base_url('impresionescontroller/processRequest');

                return $this->output->set_content_type('text/javascript')->set_output(WebClientPrint::generateScript($currentAbsoluteURL, $query));

                 
            } 
            else if ($reqType == WebClientPrint::ClientSetWcppVersion)
            {
                //This request is a ping from the WCPP utility
                //so store the session ID indicating this user has the WCPP installed
                //also store the WCPP Version if available
                if($request->has(WebClientPrint::WCPP_SET_VERSION) && strlen($request->input(WebClientPrint::WCPP_SET_VERSION)) > 0){
                    WebClientPrint::cacheAdd($sid, WebClientPrint::WCP_CACHE_WCPP_VER, $request->input(WebClientPrint::WCPP_SET_VERSION));
                }
                return;
            }
            else if ($reqType == WebClientPrint::ClientSetInstalledPrinters)
            {
                //WCPP Utility is sending the installed printers at client side
                //so store this info with the specified session ID
                WebClientPrint::cacheAdd($sid, WebClientPrint::WCP_CACHE_PRINTERS, strlen($qs[WebClientPrint::WCPP_SET_PRINTERS]) > 0 ? $qs[WebClientPrint::WCPP_SET_PRINTERS] : '');
                return;
            }
            else if ($reqType == WebClientPrint::ClientSetInstalledPrintersInfo)
            {
                //WCPP Utility is sending the installed printers at client side with detailed info
                //so store this info with the specified session ID
                //Printers Info is in JSON format
                $printersInfo = $request->input('printersInfoContent');
                 
                WebClientPrint::cacheAdd($sid, WebClientPrint::WCP_CACHE_PRINTERSINFO, $printersInfo);
                return;
            }
            else if ($reqType == WebClientPrint::ClientGetWcppVersion)
            {
                //return the WCPP version for the specified Session ID (sid) if any
                return response(WebClientPrint::cacheGet($sid, WebClientPrint::WCP_CACHE_WCPP_VER))
                        ->header('Content-Type', 'text/plain');                 
            }
            else if ($reqType == WebClientPrint::ClientGetInstalledPrinters)
            {
                //return the installed printers for the specified Session ID (sid) if any

                return $this->output->set_content_type('text/plain')->set_output(base64_decode(WebClientPrint::cacheGet($sid, WebClientPrint::WCP_CACHE_PRINTERS)));

            }    
            else if ($reqType == WebClientPrint::ClientGetInstalledPrintersInfo)
            {
                //return the installed printers with detailed info for the specified Session ID (sid) if any
                return response(base64_decode(WebClientPrint::cacheGet($sid, WebClientPrint::WCP_CACHE_PRINTERSINFO)))
                        ->header('Content-Type', 'text/plain'); 
            }    
        }
        catch (Exception $ex)
        {
            throw $ex;
        }
 
    }
}
?>

